/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpExitStateDefinition;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpNamedResource;
import de.independit.scheduler.server.dump.DumpResource;
import de.independit.scheduler.server.dump.DumpResourceStateDefinition;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.dump.DumpTriggerGeneric;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import java.util.Collections;
import java.util.Vector;

class DumpTrigger
extends DumpTriggerGeneric {
    public static final String __version = "@(#) $Id: DumpTrigger.java,v 2.9.14.1 2013/03/14 10:24:15 ronald Exp $";
    Long fireId;
    private int objectType;
    private Vector withList;
    private Vector statesList;

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = super.initialize(systemEnvironment);
        this.fireId = this.t.getFireId(systemEnvironment);
        this.objectType = this.t.getObjectType(systemEnvironment);
        String string2 = this.t.getObjectTypeAsString(systemEnvironment);
        String string3 = this.getFiredName(systemEnvironment);
        return string + "\n\ton " + string2.toLowerCase() + ' ' + string3;
    }

    DumpTrigger(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        super(systemEnvironment, sDMSTrigger);
    }

    private final String getFiredName(SystemEnvironment systemEnvironment) throws SDMSException {
        switch (this.objectType) {
            case 0: {
                return DumpSchedulingEntity.getDumpedName(systemEnvironment, this.fireId);
            }
            case 1: {
                return DumpResource.getDumpedName(systemEnvironment, this.fireId);
            }
            case 2: {
                return DumpNamedResource.getDumpedName(systemEnvironment, this.fireId);
            }
        }
        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207082241", "unknown trigger type: $1", this.objectType));
    }

    private final void loadSubmit(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.t.getSeId(systemEnvironment);
        this.withList.add("submit " + DumpSchedulingEntity.getDumpedName(systemEnvironment, l));
    }

    private final void loadType(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.t.getTypeAsString(systemEnvironment);
        this.withList.add(string.toLowerCase());
    }

    private final void loadMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.t.getIsMasterAsString(systemEnvironment);
        this.withList.add(string.toLowerCase());
    }

    private final void loadSuspend(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.t.getIsSuspendAsString(systemEnvironment);
        this.withList.add(string.toLowerCase());
    }

    private final void loadWarnOnLimit(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.t.getIsWarnOnLimit(systemEnvironment);
        if (this.objectType == 0) {
            this.withList.add(bl != false ? "warn" : "nowarn");
        }
    }

    private final void loadMaxRetry(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.t.getMaxRetry(systemEnvironment);
        if (n != 0 || this.objectType == 0) {
            this.withList.add("submitcount = " + n.toString());
        }
    }

    private final void loadJobStates(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTriggerState sDMSTriggerState = (SDMSTriggerState)vector.get(i);
            Long l = sDMSTriggerState.getToStateId(systemEnvironment);
            String string = DumpExitStateDefinition.getDumpedName(systemEnvironment, l);
            this.statesList.add(string);
        }
    }

    private final void loadResourceStates(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTriggerState sDMSTriggerState = (SDMSTriggerState)vector.get(i);
            Long l = sDMSTriggerState.getFromStateId(systemEnvironment);
            String string = l == null ? "any" : DumpResourceStateDefinition.getDumpedName(systemEnvironment, l);
            Long l2 = sDMSTriggerState.getToStateId(systemEnvironment);
            String string2 = l2 == null ? "any" : DumpResourceStateDefinition.getDumpedName(systemEnvironment, l2);
            this.statesList.add(string + "\n\t\t\t\t" + string2);
        }
    }

    private final void loadGroup(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.t.getSubmitOwnerId(systemEnvironment);
        if (l != null) {
            this.withList.add("group = " + DumpGroup.getDumpedName(systemEnvironment, l));
        }
    }

    private final void loadCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.t.getCondition(systemEnvironment);
        this.withList.add("condition = " + (string == null ? "none" : "'" + string + "'"));
    }

    private final void loadCheck(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.t.getCheckAmount(systemEnvironment);
        if (n != null) {
            String string = this.t.getCheckBaseAsString(systemEnvironment);
            this.withList.add("check = " + DumpTrigger.intervalText(n, string));
        }
    }

    private final void loadStates(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, this.tId);
        if (vector.isEmpty()) {
            return;
        }
        this.statesList = new Vector(vector.size());
        if (this.objectType == 0) {
            this.loadJobStates(systemEnvironment, vector);
        } else {
            this.loadResourceStates(systemEnvironment, vector);
        }
        Collections.sort(this.statesList, Compare.TriggerStates);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.withList = new Vector();
        this.loadSubmit(systemEnvironment);
        this.loadType(systemEnvironment);
        this.loadMaster(systemEnvironment);
        this.loadSuspend(systemEnvironment);
        this.loadWarnOnLimit(systemEnvironment);
        this.loadMaxRetry(systemEnvironment);
        this.loadGroup(systemEnvironment);
        this.loadCondition(systemEnvironment);
        this.loadCheck(systemEnvironment);
        this.loadStates(systemEnvironment);
    }

    @Override
    final void render(String string) {
        this.withList.add("states = " + (this.statesList == null ? "none" : DumpTrigger.renderList(this.statesList)));
        DumpTrigger.println(string + " trigger " + this.getName());
        DumpTrigger.println("\twith");
        DumpTrigger.println("\t\t" + DumpTrigger.join(",\n\t\t", this.withList) + ';');
    }
}

