/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.regex.Pattern;

class Output {
    private final String fnam;
    private PrintWriter fil = null;
    private final StringBuffer buf = new StringBuffer();
    private static final Pattern NAMED_RESOURCE_PATTERN = Pattern.compile("^RESOURCE(\\.'[a-zA-Z_@#][a-zA-Z_0-9@#]*')*$");
    private static final Pattern FOLDER_PATTERN = Pattern.compile("^SYSTEM(\\.'[a-zA-Z_@#][a-zA-Z_0-9@#]*')*$");
    private static final Pattern SCOPE_PATTERN = Pattern.compile("^GLOBAL(\\.'[a-zA-Z_@#][a-zA-Z_0-9@#]*')*$");
    private static final Pattern SCHEDULE_PATTERN = Pattern.compile("^ROOT(\\.'[a-zA-Z_@#][a-zA-Z_0-9@#]*')*$");
    private static final Pattern GROUP_PATTERN = Pattern.compile("^([a-zA-Z_@#][a-zA-Z_0-9@#]*)|('[a-zA-Z_@#][a-zA-Z_0-9@#]*')$");
    private int nomapStart;

    Output(String string) {
        this.fnam = string;
    }

    final void open(SystemEnvironment systemEnvironment) throws SDMSException {
        File file = new File(this.fnam);
        try {
            if (!file.createNewFile()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04412140036", "cannot create dump file: $1 already exists", this.fnam));
            }
            this.fil = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
        }
        catch (IOException iOException) {
            this.fil = null;
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04412140039", "cannot create dump file: $1", iOException));
        }
    }

    final void close() {
        if (this.fil != null) {
            this.flush();
            this.fil.close();
            this.fil = null;
        }
    }

    final void print(String string) {
        this.buf.append(string);
        if (this.buf_endsWith("\n\n")) {
            this.flush();
        }
    }

    private final boolean buf_startsWith(String string) {
        int n = string.length();
        return this.buf.length() >= n && this.buf.substring(0, n).equals(string);
    }

    private final boolean buf_endsWith(String string) {
        int n = this.buf.length() - string.length();
        return n >= 0 && this.buf.substring(n).equals(string);
    }

    private final void flush() {
        if (this.buf.length() > 0) {
            this.do_mapping();
            this.fil.print(this.buf);
            this.buf.setLength(0);
        }
    }

    private final void do_mapping() {
        this.nomapStart = this.buf.indexOf(Character.toString('\u0000'));
        if (this.nomapStart == -1) {
            this.nomapStart = this.buf.length();
        } else {
            this.buf.deleteCharAt(this.nomapStart);
        }
        if (this.buf_startsWith("cleanup ")) {
            if (!Dump.maps[12].isEmpty()) {
                this.mapAll(12, "\t", FOLDER_PATTERN, ",\n");
                this.mapAll(12, "\t", FOLDER_PATTERN, "\n\twith\n\t\t");
                this.mapAll(12, "\t", FOLDER_PATTERN, ");\n");
            }
            if (!Dump.maps[17].isEmpty()) {
                this.mapAll(17, "\t", SCOPE_PATTERN, ",\n");
                this.mapAll(17, "\t", SCOPE_PATTERN, "\n\twith\n\t\t");
                this.mapAll(17, "\t", SCOPE_PATTERN, ");\n");
            }
            return;
        }
        if (!Dump.maps[9].isEmpty()) {
            this.mapAll(9, "named_resource ", NAMED_RESOURCE_PATTERN, "\n");
            this.mapAll(9, "\t\t\t", NAMED_RESOURCE_PATTERN, ",\n");
            this.mapAll(9, "\t\t\t", NAMED_RESOURCE_PATTERN, ");\n");
            this.mapAll(9, "\t\t\t", NAMED_RESOURCE_PATTERN, "\n\t\t\t\tamount = ");
            this.mapAll(9, "alter existing resource ", NAMED_RESOURCE_PATTERN, "\n");
            this.mapAll(9, "create or alter resource ", NAMED_RESOURCE_PATTERN, "\n");
            this.mapAll(9, "\ton resource ", NAMED_RESOURCE_PATTERN, "\n");
            this.mapAll(9, "\t\t\t\treference resource ", NAMED_RESOURCE_PATTERN, " (");
        }
        if (!Dump.maps[12].isEmpty()) {
            this.mapAll(12, "folder ", FOLDER_PATTERN, "\n");
            this.mapAll(12, "job_definition ", FOLDER_PATTERN, "\n");
            this.mapAll(12, "\t\t\t", FOLDER_PATTERN, "\n");
            this.mapAll(12, "\t\t\t\treference ", FOLDER_PATTERN, " (");
            this.mapAll(12, "\t\t\t\treference child ", FOLDER_PATTERN, " (");
            this.mapAll(12, "\tin ", FOLDER_PATTERN, "\n");
            this.mapAll(12, "\t\tsubmit ", FOLDER_PATTERN, ",\n");
            this.mapAll(12, "\t\t(", FOLDER_PATTERN, ")\n");
            this.mapAll(12, "\t\taction = submit ", FOLDER_PATTERN, ",\n");
            this.mapAll(12, "\t\taction = submit ", FOLDER_PATTERN, "\n\t\t\twith\n\t\t\t\tparameters = (\n\t\t\t\t\t");
        }
        if (!Dump.maps[17].isEmpty()) {
            this.mapAll(17, "scope ", SCOPE_PATTERN, "\n");
            this.mapAll(17, "jobserver ", SCOPE_PATTERN, "\n");
            this.mapAll(17, "\tin ", SCOPE_PATTERN, "\n");
        }
        if (!Dump.maps[22].isEmpty()) {
            this.mapAll(22, "schedule ", SCHEDULE_PATTERN, "\n");
            this.mapAll(22, "scheduled_event ", SCHEDULE_PATTERN, "\n");
        }
        if (!Dump.maps[7].isEmpty()) {
            if (this.buf_startsWith("grant ")) {
                this.mapAll(7, "\ton group ", GROUP_PATTERN, "\n");
                this.mapAll(7, "\tto ", GROUP_PATTERN, ";\n");
            } else if (this.buf_startsWith("create or alter group ") || this.buf_startsWith("/* create or alter group ")) {
                this.mapAll(7, "create or alter group ", GROUP_PATTERN, ";\n");
            } else if (this.buf_startsWith("create or alter user ") || this.buf_startsWith("/* create or alter user ")) {
                this.mapAll(7, "\t\t\t", GROUP_PATTERN, ",\n");
                this.mapAll(7, "\t\t\t", GROUP_PATTERN, "),\n");
                this.mapAll(7, "\t\tdefault group = ", GROUP_PATTERN, ";\n");
            } else {
                this.mapAll(7, "\t\tgroup = ", GROUP_PATTERN, ",\n");
                this.mapAll(7, "\t\tgroup = ", GROUP_PATTERN, ";\n");
            }
        }
    }

    private final void mapAll(int n, String string, Pattern pattern, String string2) {
        int n2 = this.indexOf(string, 0);
        while (n2 != -1) {
            String string3;
            int n3 = n2 + string.length();
            int n4 = this.buf.indexOf(string2, n3);
            if (n4 != -1 && pattern.matcher(string3 = this.buf.substring(n3, n4)).matches()) {
                while (!string3.equals("")) {
                    String string4 = (String)Dump.maps[n].get(string3);
                    if (string4 == null) {
                        int n5 = Math.max(0, string3.lastIndexOf(46));
                        n4 -= string3.substring(n5).length();
                        string3 = string3.substring(0, n5);
                        continue;
                    }
                    this.buf.replace(n3, n4, string4);
                    break;
                }
            }
            n2 = this.indexOf(string, n3);
        }
    }

    private final int indexOf(String string, int n) {
        int n2 = this.buf.indexOf(string, n);
        return n2 >= this.nomapStart ? -1 : n2;
    }
}

