/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.locking;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.DeadlockException;
import de.independit.scheduler.server.exception.NotMyDeadlockException;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.locking.LockingSystemSynchronized;
import de.independit.scheduler.server.locking.ObjectLock;

public class SyncLock {
    final ObjectLock lock;

    protected SyncLock(ObjectLock objectLock) {
        this.lock = objectLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWait(SystemEnvironment systemEnvironment) throws DeadlockException, InterruptedException {
        if (this.lock.wait) {
            if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
                System.out.println(Thread.currentThread().getName() + ":doWait() on " + this.lock.objectToShortString());
            }
            this.lock.waiting = true;
            if (LockingSystem.DEADLOCK_TIMEOUT_MS == 0L) {
                boolean bl = false;
                try {
                    LockingSystem.deadlockDetection(systemEnvironment, this.lock.thread);
                }
                catch (DeadlockException deadlockException) {
                    if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_DEADLOCK_DETECTION)) != 0) {
                        System.out.println(Thread.currentThread().getName() + ":doWait() Deadlock[1] on " + this.toString());
                    }
                    throw deadlockException;
                }
                catch (NotMyDeadlockException notMyDeadlockException) {
                    bl = true;
                }
                if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
                    System.out.println(this.lock.dumpLockList());
                }
                while (this.lock.wait) {
                    SyncLock syncLock = this;
                    synchronized (syncLock) {
                        this.wait(10L);
                    }
                    if (!bl) continue;
                    bl = false;
                    try {
                        LockingSystem.deadlockDetection(systemEnvironment, this.lock.thread);
                    }
                    catch (DeadlockException deadlockException) {
                        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_DEADLOCK_DETECTION)) != 0) {
                            System.out.println(Thread.currentThread().getName() + ":doWait() Deadlock[2] on " + this.toString());
                        }
                        throw deadlockException;
                    }
                    catch (NotMyDeadlockException notMyDeadlockException) {
                        bl = true;
                    }
                }
            } else {
                boolean bl = true;
                long l = LockingSystem.DEADLOCK_TIMEOUT_MS;
                while (this.lock.wait) {
                    if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
                        System.out.println(this.lock.dumpLockList());
                    }
                    SyncLock syncLock = this;
                    synchronized (syncLock) {
                        bl = true;
                        l = true ? LockingSystem.DEADLOCK_TIMEOUT_MS : 5L;
                        this.wait(l);
                    }
                    if (!this.lock.wait || !bl) continue;
                    bl = false;
                    if ((LockingSystem.debug & LockingSystem.DEBUG_ALL) != 0) {
                        LockingSystemSynchronized.dump();
                    }
                    try {
                        LockingSystem.deadlockDetection(systemEnvironment, this.lock.thread);
                    }
                    catch (DeadlockException deadlockException) {
                        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_DEADLOCK_DETECTION)) != 0) {
                            System.out.println(Thread.currentThread().getName() + ":doWait() Deadlock[3] on " + this.toString());
                        }
                        throw deadlockException;
                    }
                    catch (NotMyDeadlockException notMyDeadlockException) {
                        bl = true;
                    }
                }
            }
            this.lock.waiting = false;
            if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
                System.out.println(Thread.currentThread().getName() + ":doWait() after wait()");
            }
        }
        LockingSystemSynchronized.resetWait(this.lock.thread);
    }

    protected synchronized void doNotify(SystemEnvironment systemEnvironment) {
        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
            System.out.println(Thread.currentThread().getName() + ":Entering doNotify() Thread " + this.lock.thread.getName() + this.toString());
        }
        if (this.lock.notify) {
            if (this.lock.waiting) {
                if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
                    System.out.println(Thread.currentThread().getName() + ":doNotify() on " + this.toString() + "]");
                }
                this.notify();
                if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
                    System.out.println(Thread.currentThread().getName() + ":Leaving doNotify() after notify()");
                }
            } else if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_WAIT_AND_NOTIFY)) != 0) {
                System.out.println(Thread.currentThread().getName() + ":Leaving doNotify() on waiting = false");
            }
            this.lock.notify = false;
        }
    }

    protected synchronized void freeObjectLock(SystemEnvironment systemEnvironment) {
        ObjectLock.freeObjectLock(systemEnvironment, this.lock);
    }

    public String toString() {
        return this.lock.toString();
    }
}

