/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.StatusTranslation;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslation;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.util.Iterator;
import java.util.Vector;

public class AlterExitStateTranslation
extends Node {
    public static final String __version = "@(#) $Id: AlterExitStateTranslation.java,v 2.5.2.4 2013/03/20 06:42:57 ronald Exp $";
    private ObjectURL url;
    private Vector trans;
    private boolean noerr;

    public AlterExitStateTranslation(ObjectURL objectURL, Vector vector, Boolean bl) {
        this.url = objectURL;
        this.trans = vector;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile;
        systemEnvironment.checkFeatureAvailability("EXIT_STATE_TRANSLATION");
        try {
            sDMSExitStateTranslationProfile = (SDMSExitStateTranslationProfile)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130023", "No Exit State Translation altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSExitStateTranslationProfile.getId(systemEnvironment);
        Vector vector = SDMSExitStateTranslationTable.idx_estpId.getVector(systemEnvironment, l);
        for (SDMSExitStateTranslation sDMSExitStateTranslation : vector) {
            sDMSExitStateTranslation.delete(systemEnvironment);
        }
        for (StatusTranslation statusTranslation : this.trans) {
            Long l2 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, statusTranslation.sfrom).getId(systemEnvironment);
            Long l3 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, statusTranslation.sto).getId(systemEnvironment);
            try {
                SDMSExitStateTranslationTable.table.create(systemEnvironment, l, l2, l3);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03110101310", "Exit State $1 is translated twice", statusTranslation.sfrom));
            }
        }
        Vector vector2 = SDMSSchedulingHierarchyTable.idx_estpId.getVector(systemEnvironment, l);
        for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy : vector2) {
            Long l4 = sDMSSchedulingHierarchy.getSeChildId(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l4);
            Long l5 = sDMSSchedulingEntity.getEspId(systemEnvironment);
            Long l6 = sDMSSchedulingHierarchy.getSeParentId(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l6);
            Long l7 = sDMSSchedulingEntity2.getEspId(systemEnvironment);
            Vector vector3 = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l5);
            Iterator iterator = vector3.iterator();
            while (iterator.hasNext()) {
                SDMSKey sDMSKey;
                Long l8 = ((SDMSExitState)iterator.next()).getEsdId(systemEnvironment);
                Long l9 = sDMSExitStateTranslationProfile.translate(systemEnvironment, l8, false);
                if (l9 == null || SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, sDMSKey = new SDMSKey(l7, l9))) continue;
                Object[] objectArray = new Object[]{SDMSExitStateDefinitionTable.getObject(systemEnvironment, l9).getName(systemEnvironment), SDMSExitStateProfileTable.getObject(systemEnvironment, l5).getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment), sDMSSchedulingEntity2.pathString(systemEnvironment), SDMSExitStateDefinitionTable.getObject(systemEnvironment, l8).getName(systemEnvironment)};
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112172122", "Parent Profile $2 of $4 does not contain translated State $1 <- $5 of $3", objectArray));
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112158", "Exit State Translation altered"));
    }
}

