/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import java.util.HashSet;
import java.util.Vector;

public class AlterPool
extends Node {
    public static final String __version = "@(#) $Id: AlterPool.java,v 2.8.4.3 2013/03/20 06:42:57 ronald Exp $";
    private final ObjectURL url;
    private final WithHash with;
    private boolean ignoreErrors;
    private static final Integer zero = SDMSConstants.iZERO;
    private Integer amount = null;
    private Integer cycle = null;
    private Long distId = null;
    private String gName = null;
    private Long gId;
    private String tag;
    private Integer traceInterval;
    private Integer traceBase;
    private Integer baseMultiplier;
    private Vector resList = null;

    public AlterPool(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.with = withHash;
        this.url = objectURL;
        this.ignoreErrors = bl;
    }

    private Long createPooledResource(SystemEnvironment systemEnvironment, Long l, SDMSProxy sDMSProxy, WithHash withHash, boolean bl) throws SDMSException {
        String string = null;
        Integer n = (Integer)withHash.get("FREEPCT");
        Integer n2 = (Integer)withHash.get("MINPCT");
        Integer n3 = (Integer)withHash.get("MAXPCT");
        Integer n4 = (Integer)withHash.get("NOMINALPCT");
        Boolean bl2 = (Boolean)withHash.get("MANAGED");
        if (bl2 == null) {
            string = "[NOT] MANAGED";
        } else if (bl2.booleanValue()) {
            if (n == null) {
                string = "FREEPCT";
            }
            if (n2 == null) {
                string = "MINPCT";
            }
            if (n3 == null) {
                string = "MAXPCT";
            }
            if (n4 == null) {
                string = "NOMINALPCT";
            }
        } else {
            n = zero;
            n2 = zero;
            n3 = zero;
            n4 = zero;
        }
        if (string != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603210956", "You did not specify the parameter $1", string));
        }
        if (bl2.booleanValue()) {
            if (n2 > n4) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161502", "MINPCT should not be larger than NOMINALPCT"));
            }
            if (n4 > n3) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161505", "NOMINALPCT should not be larger than MAXPCT"));
            }
            if (n3 > 100) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221435", "MAXPCT should not exceed 100%"));
            }
        }
        if (!sDMSProxy.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03107190910", "Insufficient privileges for adding $1", sDMSProxy.getURL(systemEnvironment)));
        }
        SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.table.create(systemEnvironment, l, sDMSProxy.getId(systemEnvironment), bl, bl2, n4, n, n2, n3, bl2, n4, n, n2, n3, zero);
        return sDMSPooledResource.getId(systemEnvironment);
    }

    private Long alterPooledResource(SystemEnvironment systemEnvironment, SDMSPooledResource sDMSPooledResource, Long l, SDMSProxy sDMSProxy, WithHash withHash, boolean bl) throws SDMSException {
        Boolean bl2 = (Boolean)withHash.get("MANAGED");
        Boolean bl3 = sDMSPooledResource.getIsManaged(systemEnvironment);
        if (bl2 == null) {
            bl2 = bl3;
        }
        sDMSPooledResource.setIsManaged(systemEnvironment, bl2);
        Integer n = (Integer)withHash.get("FREEPCT");
        Integer n2 = (Integer)withHash.get("MINPCT");
        Integer n3 = (Integer)withHash.get("MAXPCT");
        Integer n4 = (Integer)withHash.get("NOMINALPCT");
        if (n == null) {
            n = sDMSPooledResource.getFreePct(systemEnvironment);
        }
        if (n2 == null) {
            n2 = sDMSPooledResource.getMinPct(systemEnvironment);
        }
        if (n3 == null) {
            n3 = sDMSPooledResource.getMaxPct(systemEnvironment);
        }
        if (n4 == null) {
            n4 = sDMSPooledResource.getNomPct(systemEnvironment);
        }
        if (n2 > n4) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161503", "MINPCT should not be larger than NOMINALPCT"));
        }
        if (n4 > n3) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161504", "NOMINALPCT should not be larger than MAXPCT"));
        }
        if (n3 > 100) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221436", "MAXPCT should not exceed 100%"));
        }
        sDMSPooledResource.setFreePct(systemEnvironment, n);
        sDMSPooledResource.setNomPct(systemEnvironment, n4);
        sDMSPooledResource.setMinPct(systemEnvironment, n2);
        sDMSPooledResource.setMaxPct(systemEnvironment, n3);
        return sDMSPooledResource.getId(systemEnvironment);
    }

    private void checkAndRepairPool(SystemEnvironment systemEnvironment, SDMSPool sDMSPool, HashSet hashSet) throws SDMSException {
        Long l = sDMSPool.getDistId(systemEnvironment);
        boolean bl = l == null;
        Long l2 = sDMSPool.getId(systemEnvironment);
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, l2);
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
            Long l3 = sDMSPooledResource.getId(systemEnvironment);
            if (!hashSet.contains(l3)) {
                sDMSPooledResource.delete(systemEnvironment);
                continue;
            }
            n += sDMSPooledResource.getNomPct(systemEnvironment).intValue();
            if (!bl) continue;
            sDMSPooledResource.setActFreePct(systemEnvironment, sDMSPooledResource.getFreePct(systemEnvironment));
            sDMSPooledResource.setActNomPct(systemEnvironment, sDMSPooledResource.getNomPct(systemEnvironment));
            sDMSPooledResource.setActMinPct(systemEnvironment, sDMSPooledResource.getMinPct(systemEnvironment));
            sDMSPooledResource.setActMaxPct(systemEnvironment, sDMSPooledResource.getMaxPct(systemEnvironment));
            sDMSPooledResource.setActIsManaged(systemEnvironment, sDMSPooledResource.getActIsManaged(systemEnvironment));
        }
        if (n > 100) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603211542", "The sum of NOMINALPCT should not be larger than 100%"));
        }
    }

    private void alterPooledResources(SystemEnvironment systemEnvironment, SDMSPool sDMSPool) throws SDMSException {
        boolean bl = false;
        Object var4_4 = null;
        HashSet<Long> hashSet = new HashSet<Long>();
        Long l = sDMSPool.getId(systemEnvironment);
        if (this.with.containsKey("RESOURCE")) {
            this.resList = (Vector)this.with.get("RESOURCE");
        }
        if (this.resList == null) {
            return;
        }
        for (int i = 0; i < this.resList.size(); ++i) {
            SDMSProxy sDMSProxy;
            WithHash withHash = (WithHash)this.resList.get(i);
            ObjectURL objectURL = (ObjectURL)withHash.get("RESOURCE");
            if (objectURL == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161501", "You did not specify the pooled resource (or pool)", (Object)var4_4));
            }
            boolean bl2 = false;
            SDMSProxy sDMSProxy2 = objectURL.resolve(systemEnvironment);
            if (objectURL.objType == 24) {
                bl2 = true;
            } else {
                sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResource)sDMSProxy2).getNrId(systemEnvironment));
                if (sDMSProxy.getUsage(systemEnvironment) != 2) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03107190911", "Only system resources can be pooled"));
                }
                if (((SDMSResource)sDMSProxy2).getLinkId(systemEnvironment) != null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03107190912", "Resource links themselves cannot be pooled"));
                }
            }
            try {
                sDMSProxy = SDMSPooledResourceTable.idx_pId_rId_getUnique(systemEnvironment, new SDMSKey(l, objectURL.objId));
                if (hashSet.add(this.alterPooledResource(systemEnvironment, (SDMSPooledResource)sDMSProxy, l, sDMSProxy2, withHash, bl2))) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221214", "Duplicate specification of resources to be pooled"));
            }
            catch (NotFoundException notFoundException) {
                if (!sDMSProxy2.checkPrivileges(systemEnvironment, 256L)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603240944", "Insufficient privileges for adding ", sDMSProxy2.getURL(systemEnvironment)));
                }
                if (hashSet.add(this.createPooledResource(systemEnvironment, l, sDMSProxy2, withHash, bl2))) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221215", "Duplicate specification of resources to be pooled"));
            }
        }
        this.checkAndRepairPool(systemEnvironment, sDMSPool, hashSet);
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        String string = "Pool altered";
        try {
            SDMSPool sDMSPool = (SDMSPool)this.url.resolve(systemEnvironment);
            if (this.with.containsKey("CYCLE")) {
                this.cycle = (Integer)this.with.get("CYCLE");
                sDMSPool.setEvaluationCycle(systemEnvironment, this.cycle);
            }
            if (this.with.containsKey("AMOUNT")) {
                this.amount = (Integer)this.with.get("AMOUNT");
                sDMSPool.setDefinedAmount(systemEnvironment, this.amount);
                if (sDMSPool.getManagerId(systemEnvironment) == null) {
                    sDMSPool.setAmount(systemEnvironment, this.amount);
                }
            }
            this.gName = (String)this.with.get("GROUP");
            if (this.gName != null) {
                this.gId = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.gName), SDMSConstants.lZERO)).getId(systemEnvironment);
                ChownChecker.check(systemEnvironment, this.gId, sDMSPool.getOwnerId(systemEnvironment));
                sDMSPool.setOwnerId(systemEnvironment, this.gId);
            }
            if (this.with.containsKey("TAG")) {
                this.tag = (String)this.with.get("TAG");
                sDMSPool.setTag(systemEnvironment, this.tag);
            }
            if (this.with.containsKey("TRACE")) {
                this.traceInterval = (Integer)this.with.get("TRACE");
                sDMSPool.setTraceInterval(systemEnvironment, this.traceInterval);
            }
            if (this.with.containsKey("BASE")) {
                this.traceBase = (Integer)this.with.get("BASE");
                sDMSPool.setTraceBase(systemEnvironment, this.traceBase);
            }
            if (this.with.containsKey("MULTIPLIER")) {
                this.baseMultiplier = (Integer)this.with.get("MULTIPLIER");
                sDMSPool.setTraceBaseMultiplier(systemEnvironment, this.baseMultiplier);
            }
            this.alterPooledResources(systemEnvironment, sDMSPool);
        }
        catch (NotFoundException notFoundException) {
            if (this.ignoreErrors) {
                string = "No pool altered";
            }
            throw notFoundException;
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603182237", string));
    }
}

