/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipUser;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserEquiv;
import de.independit.scheduler.server.repository.SDMSUserEquivTable;
import de.independit.scheduler.server.repository.SDMSUserProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.PathVector;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;

public class AlterUser
extends ManipUser {
    public static final String __version = "@(#) $Id: AlterUser.java,v 2.5.4.1 2013/03/14 10:24:23 ronald Exp $";
    private boolean noerr;
    private boolean suActive;
    private boolean manageUser;
    private SDMSMessage feedbackMsg;

    public AlterUser(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        super(objectURL, withHash);
        this.noerr = bl;
    }

    public AlterUser(String string, WithHash withHash, Boolean bl) {
        super(string, withHash);
        this.noerr = bl;
    }

    private void commonInit(SystemEnvironment systemEnvironment) {
        this.suActive = false;
        this.manageUser = false;
        this.feedbackMsg = new SDMSMessage(systemEnvironment, "03202062029", "User altered");
    }

    private void alterParameters(SystemEnvironment systemEnvironment, SDMSUser sDMSUser) throws SDMSException {
        if (this.with.containsKey("PARAMETERS")) {
            this.createParameters(systemEnvironment, (WithHash)this.with.get("PARAMETERS"), sDMSUser);
            this.with.remove("PARAMETERS");
        }
        if (this.with.containsKey("DELPARM")) {
            this.delParameters(systemEnvironment, sDMSUser, (Vector)this.with.get("DELPARM"), false);
            this.with.remove("DELPARM");
        }
        if (this.with.containsKey("XDELPARM")) {
            this.delParameters(systemEnvironment, sDMSUser, (Vector)this.with.get("XDELPARM"), true);
            this.with.remove("XDELPARM");
        }
        if (this.with.containsKey("ALTPARM")) {
            this.addOrAlterParameters(systemEnvironment, (WithHash)this.with.get("ALTPARM"), sDMSUser, false, false);
            this.with.remove("ALTPARM");
        }
        if (this.with.containsKey("XALTPARM")) {
            this.addOrAlterParameters(systemEnvironment, (WithHash)this.with.get("XALTPARM"), sDMSUser, false, true);
            this.with.remove("XALTPARM");
        }
        if (this.with.containsKey("ADDPARM")) {
            this.addOrAlterParameters(systemEnvironment, (WithHash)this.with.get("ADDPARM"), sDMSUser, true, false);
            this.with.remove("ADDPARM");
        }
        if (this.with.containsKey("XADDPARM")) {
            this.addOrAlterParameters(systemEnvironment, (WithHash)this.with.get("XADDPARM"), sDMSUser, true, true);
            this.with.remove("XADDPARM");
        }
    }

    private void alterByUser(SystemEnvironment systemEnvironment, SDMSUser sDMSUser) throws SDMSException {
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(SDMSObject.adminGId);
        systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
        try {
            if (this.passwd != null) {
                sDMSUser.setPasswd(systemEnvironment, this.passwd);
                sDMSUser.setSalt(systemEnvironment, this.salt);
                sDMSUser.setMethod(systemEnvironment, this.method);
            }
            if (this.with.containsKey("DEFAULTGROUP")) {
                sDMSUser.setDefaultGId(systemEnvironment, this.defaultGId);
                this.with.remove("DEFAULTGROUP");
            }
            this.alterParameters(systemEnvironment, sDMSUser);
        }
        finally {
            systemEnvironment.cEnv.popGid(systemEnvironment);
        }
        this.result.setFeedback(this.feedbackMsg);
    }

    private void setSystemPwd(SystemEnvironment systemEnvironment) throws SDMSException {
        if (systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
            Properties properties = new Properties();
            String string = SystemEnvironment.server.getIniFile();
            InputStream inputStream = Server.class.getResourceAsStream(string);
            try {
                if (inputStream == null) {
                    inputStream = new FileInputStream(string);
                }
                properties.load(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                SDMSThread.doTrace(null, "Properties File not found : " + fileNotFoundException, -1);
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03501211409", "Change of SYSTEM password failed: Properties File not found"));
            }
            catch (IOException iOException) {
                SDMSThread.doTrace(null, "Error loading Properties file: " + iOException, -1);
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03501211410", "Change of SYSTEM password failed: Error loading Properties file"));
            }
            String string2 = properties.getProperty("SysPasswd");
            if (!this.txtPasswd.equals(string2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03501211411", "Change of SYSTEM password failed: Password in configuration file " + string + " must be changed first"));
            }
        } else {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03102151020", "Insufficient privileges accessing User SYSTEM"));
        }
        SystemEnvironment.sysPasswd = this.txtPasswd;
        this.feedbackMsg = new SDMSMessage(systemEnvironment, "03102151013", "SYSTEM Password changed");
    }

    private void alterGroups(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.with.containsKey("GROUPLIST")) {
            int n;
            Long l2;
            Vector vector = SDMSMemberTable.idx_uId.getVector(systemEnvironment, l);
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                boolean bl = true;
                SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
                for (int i = 0; i < this.grouplist.size(); ++i) {
                    l2 = (Long)this.grouplist.get(i);
                    if (systemEnvironment.cEnv.gid().contains(l2)) continue;
                    bl = false;
                    for (int j = 0; j < vector.size(); ++j) {
                        SDMSMember sDMSMember = (SDMSMember)vector.get(j);
                        Long l3 = sDMSMember.getGId(systemEnvironment);
                        if (!l2.equals(l3)) continue;
                        bl = true;
                    }
                    if (!bl) break;
                }
                if (bl && this.manageUser) {
                    HashSet<Long> hashSet = new HashSet<Long>();
                    hashSet.add(SDMSObject.adminGId);
                    systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
                    this.suActive = true;
                }
            }
            if (!this.grouplist.contains(this.defaultGId) && !this.publicGId.equals(this.defaultGId)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03401271115", "You cannot remove the default group"));
            }
            for (n = 0; n < vector.size(); ++n) {
                SDMSMember sDMSMember = (SDMSMember)vector.get(n);
                l2 = sDMSMember.getGId(systemEnvironment);
                if (!(this.grouplist.contains(l2) || l2.equals(this.publicGId) || l2.equals(this.defaultGId))) {
                    sDMSMember.delete(systemEnvironment);
                    continue;
                }
                this.grouplist.remove(l2);
            }
            for (n = 0; n < this.grouplist.size(); ++n) {
                Long l4 = (Long)this.grouplist.get(n);
                SDMSThread.doTrace(systemEnvironment.cEnv, "uId = " + l + ", gId = " + l4 + ", defaultGId = " + this.defaultGId + ", publicGId = " + this.publicGId, 3);
                if (l4.equals(this.defaultGId) || l4.equals(this.publicGId)) continue;
                SDMSMemberTable.table.create(systemEnvironment, l4, l);
            }
            try {
                SDMSMemberTable.table.create(systemEnvironment, this.defaultGId, l);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
            if (this.suActive) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
                this.suActive = false;
            }
        }
        if (this.with.containsKey("ADDGROUP")) {
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                boolean bl = true;
                SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
                for (int i = 0; i < this.addlist.size(); ++i) {
                    Long l5 = (Long)this.addlist.get(i);
                    if (systemEnvironment.cEnv.gid().contains(l5)) continue;
                    bl = false;
                    break;
                }
                if (bl && this.manageUser) {
                    HashSet<Long> hashSet = new HashSet<Long>();
                    hashSet.add(SDMSObject.adminGId);
                    systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
                    this.suActive = true;
                }
            }
            for (int i = 0; i < this.addlist.size(); ++i) {
                Long l6 = (Long)this.addlist.get(i);
                if (l6.equals(this.defaultGId)) continue;
                try {
                    SDMSMemberTable.table.create(systemEnvironment, l6, l);
                    continue;
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    // empty catch block
                }
            }
            if (this.suActive) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
            }
        }
        if (this.with.containsKey("DELGROUP")) {
            if (this.manageUser) {
                HashSet<Long> hashSet = new HashSet<Long>();
                hashSet.add(SDMSObject.adminGId);
                systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
                this.suActive = true;
            }
            for (int i = 0; i < this.dellist.size(); ++i) {
                Long l7 = (Long)this.dellist.get(i);
                if (!l7.equals(this.defaultGId)) {
                    if (l7.equals(this.publicGId)) continue;
                    try {
                        SDMSMember sDMSMember = SDMSMemberTable.idx_gId_uId_getUnique(systemEnvironment, new SDMSKey(l7, l));
                        sDMSMember.delete(systemEnvironment);
                    }
                    catch (NotFoundException notFoundException) {}
                    continue;
                }
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312102203", "You cannot remove the default group"));
            }
            if (this.suActive) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
            }
        }
    }

    private void alterEquivalences(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSUserEquivTable.idx_uId.getVector(systemEnvironment, l);
        if (this.userEquiv == null) {
            for (int i = 0; i < vector.size(); ++i) {
                SDMSUserEquiv sDMSUserEquiv = (SDMSUserEquiv)vector.get(i);
                sDMSUserEquiv.delete(systemEnvironment);
            }
        } else {
            Long l2;
            int n;
            for (n = 0; n < vector.size(); ++n) {
                Object object;
                SDMSUserEquiv sDMSUserEquiv = (SDMSUserEquiv)vector.get(n);
                l2 = sDMSUserEquiv.getAltUId(systemEnvironment);
                try {
                    SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l2);
                    object = sDMSUser.getName(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l2);
                    object = sDMSScope.pathVector(systemEnvironment);
                }
                if (this.userEquiv.contains(object)) {
                    this.userEquiv.remove(object);
                    continue;
                }
                sDMSUserEquiv.delete(systemEnvironment);
            }
            for (n = 0; n < this.userEquiv.size(); ++n) {
                SDMSProxy sDMSProxy;
                l2 = this.userEquiv.get(n);
                if (l2 instanceof String) {
                    sDMSProxy = SDMSUserTable.idx_name_getUnique(systemEnvironment, (String)((Object)l2));
                    if (!((SDMSUserProxyGeneric)sDMSProxy).getDeleteVersion(systemEnvironment).equals(SDMSConstants.lZERO)) {
                        throw new NotFoundException(new SDMSMessage(systemEnvironment, "03707311522", "User " + ((Object)l2).toString() + " not found"));
                    }
                    SDMSUserEquivTable.table.create(systemEnvironment, l, SDMSConstants.UE_USER, sDMSProxy.getId(systemEnvironment));
                    continue;
                }
                if (!(l2 instanceof PathVector)) continue;
                sDMSProxy = SDMSScopeTable.getScope(systemEnvironment, (PathVector)((Object)l2));
                if (((SDMSScopeProxyGeneric)sDMSProxy).getType(systemEnvironment) != 2) {
                    throw new NotFoundException(new SDMSMessage(systemEnvironment, "03707311523", "No job server " + ((Object)l2).toString() + " found"));
                }
                SDMSUserEquivTable.table.create(systemEnvironment, l, SDMSConstants.UE_SERVER, sDMSProxy.getId(systemEnvironment));
                continue;
            }
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSUser sDMSUser;
        this.commonInit(systemEnvironment);
        this.salt = AlterUser.generateSalt();
        this.evaluate_with(systemEnvironment);
        try {
            sDMSUser = this.url == null ? SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.user), SDMSConstants.lZERO)) : (SDMSUser)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311121715", "No user altered"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSUser.getId(systemEnvironment);
        if (this.defaultGId == null) {
            this.defaultGId = sDMSUser.getDefaultGId(systemEnvironment);
        }
        if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
            SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
            for (Long l2 : systemEnvironment.cEnv.gid()) {
                try {
                    SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(SDMSConstants.lZERO, l2));
                    sDMSPrivilege.addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {}
            }
            if (sDMSPrivilege.can(0x400000000L)) {
                this.manageUser = true;
            }
        } else {
            this.manageUser = true;
        }
        if (systemEnvironment.cEnv.uid().equals(l) && l != 0L) {
            this.alterByUser(systemEnvironment, sDMSUser);
            if (!this.manageUser) {
                if (this.with.size() != 0) {
                    throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03011101420", "Insufficient privileges"));
                }
                return;
            }
        } else {
            if (this.passwd != null && l != 0L) {
                sDMSUser.setPasswd(systemEnvironment, this.passwd);
                sDMSUser.setSalt(systemEnvironment, this.salt);
                sDMSUser.setMethod(systemEnvironment, this.method);
            } else if (this.passwd != null) {
                this.setSystemPwd(systemEnvironment);
            }
            if (this.with.containsKey("DEFAULTGROUP")) {
                sDMSUser.setDefaultGId(systemEnvironment, this.defaultGId);
            }
            this.alterParameters(systemEnvironment, sDMSUser);
        }
        if (this.with.containsKey("ENABLE")) {
            sDMSUser.setIsEnabled(systemEnvironment, this.enable);
        }
        try {
            this.alterGroups(systemEnvironment, l);
        }
        catch (Throwable throwable) {
            if (this.suActive) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
            }
            throw throwable;
        }
        if (this.with.containsKey("CONNECT")) {
            sDMSUser.setConnectionType(systemEnvironment, (Integer)this.with.get("CONNECT"));
        }
        if (systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId) && this.with.containsKey("EQUIVALENT")) {
            this.alterEquivalences(systemEnvironment, l);
        }
        if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(this.defaultGId, l))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312130121", "a user must belong to his default group"));
        }
        this.result.setFeedback(this.feedbackMsg);
    }
}

