/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipJob;
import de.independit.scheduler.server.repository.SDMSEntityVariable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import de.independit.scheduler.server.repository.SDMSSystemMessageTable;
import java.util.HashSet;

public class ApproveCmd
extends ManipJob {
    final boolean isApproval;
    final HashSet idList;

    public ApproveCmd(boolean bl, HashSet hashSet, String string) {
        this.isApproval = bl;
        this.idList = hashSet;
        this.comment = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        for (Long l : this.idList) {
            Comparable<Long> comparable;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            SDMSPrivilege sDMSPrivilege;
            SDMSSystemMessage sDMSSystemMessage;
            try {
                sDMSSystemMessage = SDMSSystemMessageTable.getObject(systemEnvironment, l);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            if (sDMSSystemMessage.getMsgType(systemEnvironment) != 1 || sDMSSystemMessage.getRequestUId(systemEnvironment).equals(systemEnvironment.cEnv.uid()) && !systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId) || !(sDMSPrivilege = (sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSSystemMessage.getSmeId(systemEnvironment))).getPrivileges(systemEnvironment)).can(512L)) continue;
            if (!this.isApproval) {
                this.performReject(systemEnvironment, sDMSSystemMessage, sDMSSubmittedEntity);
            } else if (sDMSSystemMessage.getIsMandatory(systemEnvironment).booleanValue()) {
                int n = sDMSSystemMessage.getOperation(systemEnvironment);
                switch (n) {
                    case 7: {
                        this.message = "Clone request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        comparable = this.performClone(systemEnvironment, sDMSSubmittedEntity);
                        Long l2 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                        Long l3 = sDMSSystemMessage.getSecondLong(systemEnvironment);
                        if (l2 != null) {
                            this.evalSuspend(systemEnvironment, l2, l3, (SDMSSubmittedEntity)comparable);
                            break;
                        }
                        ((SDMSSubmittedEntity)comparable).resume(systemEnvironment, true);
                        break;
                    }
                    case 1: {
                        this.message = "Cancel request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                        if (bl) {
                            this.killRecursive = true;
                            this.performKill(systemEnvironment, sDMSSubmittedEntity);
                        }
                        this.performCancel(systemEnvironment, sDMSSubmittedEntity);
                        break;
                    }
                    case 2: {
                        this.message = "Rerun request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        Boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                        if (bl == null) {
                            throw new FatalException(new SDMSMessage(systemEnvironment, "03106211054", "Insufficient data available for rerun"));
                        }
                        this.performRerun(systemEnvironment, sDMSSubmittedEntity, bl);
                        Long l2 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                        Long l3 = sDMSSystemMessage.getSecondLong(systemEnvironment);
                        if (l2 == null) break;
                        this.evalSuspend(systemEnvironment, l2, l3, sDMSSubmittedEntity);
                        break;
                    }
                    case 3: 
                    case 23: {
                        Boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                        this.message = (bl != false ? "Disable" : "Enable") + " request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        if (bl == null) {
                            throw new FatalException(new SDMSMessage(systemEnvironment, "03106211214", "Insufficient data available for enable/disable"));
                        }
                        this.performDisable(systemEnvironment, sDMSSubmittedEntity, bl);
                        Long l2 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                        Long l3 = sDMSSystemMessage.getSecondLong(systemEnvironment);
                        if (l2 == null) break;
                        this.evalSuspend(systemEnvironment, l2, l3, sDMSSubmittedEntity);
                        break;
                    }
                    case 4: {
                        Long l4;
                        this.message = "Set state request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        Boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                        if (bl == null) {
                            bl = Boolean.FALSE;
                        }
                        if ((l4 = sDMSSystemMessage.getAdditionalLong(systemEnvironment)) == null) {
                            throw new FatalException(new SDMSMessage(systemEnvironment, "03106291214", "Insufficient data available for set state"));
                        }
                        this.performSetState(systemEnvironment, sDMSSubmittedEntity, l4, bl);
                        break;
                    }
                    case 5: {
                        this.message = "Ignore dependency request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        Boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                        Long l5 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                        if (bl == null || l5 == null) {
                            throw new FatalException(new SDMSMessage(systemEnvironment, "03106211215", "Insufficient data available for ignore dependency [recursive]"));
                        }
                        this.performIgnDep(systemEnvironment, sDMSSubmittedEntity, l5, bl);
                        break;
                    }
                    case 6: {
                        this.message = "Ignore resource request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        Long l6 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                        if (l6 == null) {
                            throw new FatalException(new SDMSMessage(systemEnvironment, "03106211216", "Insufficient data available for ignore resource"));
                        }
                        this.performIgnRss(systemEnvironment, sDMSSubmittedEntity, l6);
                        break;
                    }
                    case 11: {
                        this.message = "Set parameter request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        String string = sDMSSystemMessage.getComment(systemEnvironment);
                        SDMSEntityVariable sDMSEntityVariable = SDMSEntityVariableTable.getObject(systemEnvironment, sDMSSystemMessage.getAdditionalLong(systemEnvironment));
                        String string2 = sDMSEntityVariable.getValue(systemEnvironment);
                        this.performModParm(systemEnvironment, sDMSSubmittedEntity, string, string2);
                        break;
                    }
                    case 12: {
                        this.message = "Kill request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        this.killRecursive = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                        this.performKill(systemEnvironment, sDMSSubmittedEntity);
                        break;
                    }
                    case 13: {
                        this.message = "Set job state request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                        this.status = sDMSSystemMessage.getAdditionalLong(systemEnvironment).intValue();
                        Long l7 = sDMSSystemMessage.getSecondLong(systemEnvironment);
                        this.exitCode = l7 != null ? Integer.valueOf(l7.intValue()) : null;
                        this.performSetJobState(systemEnvironment, sDMSSubmittedEntity);
                    }
                }
            } else {
                String string = "Request " + sDMSSystemMessage.getId(systemEnvironment) + " approved";
                comparable = sDMSSubmittedEntity.getId(systemEnvironment);
                this.writeAudit(systemEnvironment, (Long)comparable, SDMSConstants.AT_APPROVE, string);
            }
            try {
                sDMSSystemMessage.delete(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {}
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03105281231", "Job actions " + (this.isApproval ? "approved" : "rejected")));
    }
}

