/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import java.util.Vector;

public class CopyScope
extends Node {
    public static final String __version = "@(#) $Id: CopyScope.java,v 2.4.2.1 2013/03/14 10:24:24 ronald Exp $";
    private Vector name2;
    private ObjectURL url;
    private String newName;

    public CopyScope(ObjectURL objectURL, Vector vector) {
        this.url = objectURL;
        this.name2 = vector;
        this.newName = null;
    }

    public CopyScope(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.name2 = null;
        this.newName = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        String string;
        SDMSScope sDMSScope;
        SDMSScope sDMSScope2 = (SDMSScope)this.url.resolve(systemEnvironment);
        Long l2 = sDMSScope2.getParentId(systemEnvironment);
        if (l2 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112191230", "The scope GLOBAL cannot be copied"));
        }
        if (this.newName == null) {
            try {
                sDMSScope = SDMSScopeTable.getScope(systemEnvironment, this.name2);
                string = sDMSScope2.getName(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                string = (String)this.name2.remove(this.name2.size() - 1);
                sDMSScope = SDMSScopeTable.getScope(systemEnvironment, this.name2);
            }
        } else {
            sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l2);
            string = this.newName;
        }
        if (sDMSScope.getType(systemEnvironment) == 2) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204171911", "A scope cannot be copied below a Server"));
        }
        Long l3 = sDMSScope.getId(systemEnvironment);
        if (SDMSScopeTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l3, (Comparable)((Object)string)))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112191233", "A scope with name $1 already exists within $2", string, sDMSScope.pathString(systemEnvironment)));
        }
        Long l4 = sDMSScope2.getId(systemEnvironment);
        if (l3.equals(l4)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204171912", "A Scope cannot be copied below itself"));
        }
        while ((l = sDMSScope.getParentId(systemEnvironment)) != null) {
            if (l.equals(l4)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204171913", "A Scope cannot be copied below itself"));
            }
            sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
        }
        sDMSScope2.copy(systemEnvironment, l3, string);
        SystemEnvironment.sched.notifyChange(systemEnvironment, (SDMSScope)null, 11);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202201950", "Scope copied"));
    }
}

