/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterPool;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.HashSet;
import java.util.Vector;

public class CreatePool
extends Node {
    public static final String __version = "@(#) $Id: CreatePool.java,v 2.8.4.3 2013/03/20 06:42:58 ronald Exp $";
    private final WithHash with;
    private final boolean replace;
    private Vector resList = null;
    private Integer amount = SDMSConstants.iZERO;
    private Integer cycle = SDMSConstants.iZERO;
    private Long distId = null;
    private String gName = null;
    private final ObjectURL url;
    private String tag;
    private Integer traceInterval;
    private Integer traceBase;
    private Integer baseMultiplier;
    private Long gId;

    public CreatePool(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.with = withHash;
        this.url = objectURL;
        this.replace = bl;
    }

    private void createPooledResources(SystemEnvironment systemEnvironment, SDMSPool sDMSPool) throws SDMSException {
        int n = 0;
        String string = null;
        HashSet<Long> hashSet = new HashSet<Long>();
        Long l = sDMSPool.getId(systemEnvironment);
        if (this.with.containsKey("RESOURCE")) {
            this.resList = (Vector)this.with.get("RESOURCE");
        }
        if (this.resList == null) {
            return;
        }
        for (int i = 0; i < this.resList.size(); ++i) {
            SDMSProxy sDMSProxy;
            WithHash withHash = (WithHash)this.resList.get(i);
            Integer n2 = (Integer)withHash.get("FREEPCT");
            Integer n3 = (Integer)withHash.get("MINPCT");
            Integer n4 = (Integer)withHash.get("MAXPCT");
            Integer n5 = (Integer)withHash.get("NOMINALPCT");
            Boolean bl = (Boolean)withHash.get("MANAGED");
            ObjectURL objectURL = (ObjectURL)withHash.get("RESOURCE");
            Boolean bl2 = Boolean.FALSE;
            if (objectURL == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161456", "You did not specify the pooled resource (or pool)", string));
            }
            if (bl == null) {
                string = "[NOT] MANAGED";
            }
            if (n2 == null) {
                string = "FREEPCT";
            }
            if (n3 == null) {
                string = "MINPCT";
            }
            if (n4 == null) {
                string = "MAXPCT";
            }
            if (n5 == null) {
                string = "NOMINALPCT";
            }
            if (string != null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161457", "You did not specify the parameter $1", string));
            }
            if (n3 > n5) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161458", "MINPCT should not be larger than NOMINALPCT"));
            }
            if (n5 > n4) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161459", "NOMINALPCT should not be larger than MAXPCT"));
            }
            if (n4 > 100) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221434", "MAXPCT should not exceed 100%"));
            }
            if (bl.booleanValue()) {
                n += n5.intValue();
            }
            SDMSProxy sDMSProxy2 = objectURL.resolve(systemEnvironment);
            Long l2 = sDMSProxy2.getId(systemEnvironment);
            if (!sDMSProxy2.checkPrivileges(systemEnvironment, 256L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03603240938", "Insufficient privileges for adding $1", sDMSProxy2.getURL(systemEnvironment)));
            }
            if (objectURL.objType == 24) {
                bl2 = Boolean.TRUE;
            } else {
                sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResource)sDMSProxy2).getNrId(systemEnvironment));
                if (((SDMSNamedResourceProxyGeneric)sDMSProxy).getUsage(systemEnvironment) != 2) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221711", "Only system resources can be pooled"));
                }
                if (((SDMSResource)sDMSProxy2).getLinkId(systemEnvironment) != null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03107190907", "Resource links themselves cannot be pooled"));
                }
            }
            if (!hashSet.add(l2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221212", "Duplicate specification of resources to be pooled"));
            }
            sDMSProxy = SDMSPooledResourceTable.table.create(systemEnvironment, l, l2, bl2, bl, n5, n2, n3, n4, bl, n5, n2, n3, n4, SDMSConstants.iZERO);
            if (!bl.booleanValue()) continue;
            if (bl2.booleanValue()) {
                ((SDMSPool)sDMSProxy2).setManagerId(systemEnvironment, sDMSProxy.getId(systemEnvironment));
                continue;
            }
            ((SDMSResource)sDMSProxy2).setManagerId(systemEnvironment, sDMSProxy.getId(systemEnvironment));
        }
        if (n > 100) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603161500", "The sum of NOMINALPCT should not exceed 100%"));
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        this.url.master.resolve(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.url.path);
        this.cycle = this.with.containsKey("CYCLE") ? (Integer)this.with.get("CYCLE") : null;
        this.amount = this.with.containsKey("AMOUNT") ? (Integer)this.with.get("AMOUNT") : SDMSConstants.iZERO;
        this.gName = (String)this.with.get("GROUP");
        this.gId = this.gName != null ? SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.gName), SDMSConstants.lZERO)).getId(systemEnvironment) : SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid()).getDefaultGId(systemEnvironment);
        this.tag = (String)this.with.get("TAG");
        this.traceInterval = (Integer)this.with.get("TRACE");
        this.traceBase = (Integer)this.with.get("BASE");
        this.baseMultiplier = (Integer)this.with.get("MULTIPLIER");
        if (this.baseMultiplier == null) {
            this.baseMultiplier = 600;
        }
        try {
            SDMSPool sDMSPool = SDMSPoolTable.table.create(systemEnvironment, sDMSNamedResource.getId(systemEnvironment), this.url.master.objId, this.gId, null, this.distId, this.amount, this.amount, this.amount, SDMSConstants.iZERO, this.cycle, SDMSConstants.lZERO, null, this.traceInterval, this.traceBase, this.baseMultiplier, SDMSConstants.fZERO, SDMSConstants.fZERO, SDMSConstants.fZERO, SDMSConstants.fZERO, SDMSConstants.lZERO, SDMSConstants.lZERO);
            if (this.tag != null) {
                sDMSPool.setTag(systemEnvironment, this.tag);
            }
            this.createPooledResources(systemEnvironment, sDMSPool);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterPool alterPool = new AlterPool(this.url, this.with, Boolean.FALSE);
                alterPool.setEnv(this.env);
                alterPool.go(systemEnvironment);
                this.result = alterPool.result;
                return;
            }
            throw duplicateKeyException;
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603151712", "Pool created"));
    }
}

