/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class DropExitStatProf
extends Node {
    public static final String __version = "@(#) $Id: DropExitStatProf.java,v 2.3.4.1 2013/03/14 10:24:29 ronald Exp $";
    private ObjectURL url;
    private boolean noerr;

    public DropExitStatProf(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateProfile sDMSExitStateProfile;
        try {
            sDMSExitStateProfile = (SDMSExitStateProfile)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130011", "No Exit State Profile dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSExitStateProfile.getId(systemEnvironment);
        Vector vector = SDMSSchedulingEntityTable.idx_espId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112171835", "Exit State Profile in use by $1", ((SDMSSchedulingEntity)vector.elementAt(0)).pathString(systemEnvironment)));
        }
        Vector vector2 = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l);
        for (SDMSExitState sDMSExitState : vector2) {
            sDMSExitState.delete(systemEnvironment);
        }
        sDMSExitStateProfile.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112214", "Exit State Profile dropped"));
    }
}

