/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class DropExitStateMapping
extends Node {
    public static final String __version = "@(#) $Id: DropExitStateMapping.java,v 2.2.14.1 2013/03/14 10:24:29 ronald Exp $";
    private final ObjectURL url;
    private boolean noerr;

    public DropExitStateMapping(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateMappingProfile sDMSExitStateMappingProfile;
        try {
            sDMSExitStateMappingProfile = (SDMSExitStateMappingProfile)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122353", "No Exit State Mapping dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSExitStateMappingProfile.getId(systemEnvironment);
        Vector vector = SDMSExitStateProfileTable.idx_defaultEsmpId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02111082000", "Exit State Mapping is default in Exit State Profile $1", ((SDMSExitStateProfile)vector.elementAt(0)).getName(systemEnvironment)));
        }
        Vector vector2 = SDMSSchedulingEntityTable.idx_esmpId.getVector(systemEnvironment, l);
        if (vector2.size() != 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112171836", "Exit State Mapping in use by $1", ((SDMSSchedulingEntity)vector2.elementAt(0)).pathString(systemEnvironment)));
        }
        Vector vector3 = SDMSExitStateMappingTable.idx_esmpId.getVector(systemEnvironment, l);
        for (SDMSExitStateMapping sDMSExitStateMapping : vector3) {
            sDMSExitStateMapping.delete(systemEnvironment);
        }
        sDMSExitStateMappingProfile.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201212211", "Exit State Mapping dropped"));
    }
}

