/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;

public class DropJobDefinition
extends Node {
    public static final String __version = "@(#) $Id: DropJobDefinition.java,v 2.7.4.2 2013/03/19 17:16:46 ronald Exp $";
    private ObjectURL url;
    Boolean force;
    boolean ignoreNotFound;

    public DropJobDefinition(ObjectURL objectURL, Boolean bl, boolean bl2) {
        this.url = objectURL;
        this.force = bl;
        this.ignoreNotFound = bl2;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity;
        try {
            sDMSSchedulingEntity = (SDMSSchedulingEntity)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.ignoreNotFound) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03301291253", "Job Definition dropped"));
                return;
            }
            throw notFoundException;
        }
        sDMSSchedulingEntity.delete(systemEnvironment, this.force);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112232", "Job Definition dropped"));
    }
}

