/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberProxyGeneric;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserEquiv;
import de.independit.scheduler.server.repository.SDMSUserEquivProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserEquivTable;
import java.util.HashSet;
import java.util.Vector;

public class DropUser
extends Node {
    public static final String __version = "@(#) $Id: DropUser.java,v 2.5.4.1 2013/03/14 10:24:31 ronald Exp $";
    private ObjectURL url;
    private boolean noerr;

    public DropUser(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSUser sDMSUser;
        try {
            sDMSUser = (SDMSUser)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311121718", "No user dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSUser.getId(systemEnvironment);
        boolean bl = false;
        try {
            int n;
            Object object3;
            Object object2;
            if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                object2 = new SDMSPrivilege();
                for (Object object3 : systemEnvironment.cEnv.gid()) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(SDMSConstants.lZERO, (Comparable)object3));
                        ((SDMSPrivilege)object2).addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
                    }
                    catch (NotFoundException notFoundException) {}
                }
                if (((SDMSPrivilege)object2).can(0x400000000L)) {
                    object3 = new HashSet();
                    ((HashSet)object3).add(SDMSObject.adminGId);
                    systemEnvironment.cEnv.pushGid(systemEnvironment, (HashSet)object3);
                    bl = true;
                } else {
                    throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03408281223", "Insufficient Privileges"));
                }
            }
            object2 = SDMSMemberTable.idx_uId.getVector(systemEnvironment, l);
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object3 = (SDMSMember)((Vector)object2).get(n);
                ((SDMSMemberProxyGeneric)object3).delete(systemEnvironment);
            }
            object2 = SDMSUserEquivTable.idx_uId.getVector(systemEnvironment, l);
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object3 = (SDMSUserEquiv)((Vector)object2).get(n);
                ((SDMSUserEquivProxyGeneric)object3).delete(systemEnvironment);
            }
            object2 = SDMSUserEquivTable.idx_altUId.getVector(systemEnvironment, l);
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                object3 = (SDMSUserEquiv)((Vector)object2).get(n);
                ((SDMSUserEquivProxyGeneric)object3).delete(systemEnvironment);
            }
            sDMSUser.setIsEnabled(systemEnvironment, Boolean.FALSE);
            sDMSUser.setDeleteVersion(systemEnvironment, systemEnvironment.tx.txId);
            if (bl) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
            }
            throw throwable;
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03301272337", "User dropped"));
    }
}

