/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.DumpExpandItem;
import de.independit.scheduler.server.parser.DumpObject;
import de.independit.scheduler.server.parser.DumpRule;
import de.independit.scheduler.server.parser.ExpandParser;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.parser.dumpClasses.DumpF;
import de.independit.scheduler.server.parser.dumpClasses.DumpLine;
import de.independit.scheduler.server.parser.expandClasses.NoneComment;
import de.independit.scheduler.server.parser.expandClasses.NoneDistribution;
import de.independit.scheduler.server.parser.expandClasses.NoneEnvironment;
import de.independit.scheduler.server.parser.expandClasses.NoneEvent;
import de.independit.scheduler.server.parser.expandClasses.NoneExitStateDefinition;
import de.independit.scheduler.server.parser.expandClasses.NoneExitStateMapping;
import de.independit.scheduler.server.parser.expandClasses.NoneExitStateProfile;
import de.independit.scheduler.server.parser.expandClasses.NoneExitStateTranslation;
import de.independit.scheduler.server.parser.expandClasses.NoneFolder;
import de.independit.scheduler.server.parser.expandClasses.NoneFootprint;
import de.independit.scheduler.server.parser.expandClasses.NoneGrant;
import de.independit.scheduler.server.parser.expandClasses.NoneGroup;
import de.independit.scheduler.server.parser.expandClasses.NoneInterval;
import de.independit.scheduler.server.parser.expandClasses.NoneNamedResource;
import de.independit.scheduler.server.parser.expandClasses.NoneNiceProfile;
import de.independit.scheduler.server.parser.expandClasses.NoneObjectMonitor;
import de.independit.scheduler.server.parser.expandClasses.NonePool;
import de.independit.scheduler.server.parser.expandClasses.NoneResource;
import de.independit.scheduler.server.parser.expandClasses.NoneResourceStateDefinition;
import de.independit.scheduler.server.parser.expandClasses.NoneResourceStateMapping;
import de.independit.scheduler.server.parser.expandClasses.NoneResourceStateProfile;
import de.independit.scheduler.server.parser.expandClasses.NoneResourceTemplate;
import de.independit.scheduler.server.parser.expandClasses.NoneSchedule;
import de.independit.scheduler.server.parser.expandClasses.NoneScheduledEvent;
import de.independit.scheduler.server.parser.expandClasses.NoneSchedulingEntity;
import de.independit.scheduler.server.parser.expandClasses.NoneScope;
import de.independit.scheduler.server.parser.expandClasses.NoneTrigger;
import de.independit.scheduler.server.parser.expandClasses.NoneUser;
import de.independit.scheduler.server.parser.expandClasses.NoneWatchType;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.PathVector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class DumpCommand
extends Node {
    public static final String __version = "@(#) $Id: DumpCommand.java,v 2.21.4.3 2013/06/18 09:49:31 ronald Exp $";
    final Vector dumpList;
    final WithHash with;
    final String filename;
    Vector expandRules;

    public DumpCommand(Vector vector, WithHash withHash, String string) {
        this.dumpList = vector;
        this.filename = string;
        this.with = withHash == null ? new WithHash() : withHash;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public String syntaxCheck() {
        String string = null;
        if (this.with == null) {
            return null;
        }
        Vector vector = (Vector)this.with.get("EXPAND");
        if (vector == null) {
            return null;
        }
        string = ExpandParser.checkExpandRules(vector);
        if ((vector = ExpandParser.expandCompoundRules(vector)) == null) {
            return "Syntax Error in expand rules";
        }
        this.expandRules = vector = ExpandParser.mergeRules(vector);
        return string;
    }

    private final String makeOutput(Vector vector) {
        Object[] objectArray = vector.toArray();
        int n = 0;
        Arrays.sort(objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.with.containsKey("MULTICOMMAND")) {
            ++n;
        }
        if (this.with.containsKey("HEADER")) {
            ++n;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (i >= n) {
                stringBuffer.append("/* " + (i - n + 1) + " */\n");
            }
            stringBuffer.append(((DumpLine)objectArray[i]).line);
        }
        return stringBuffer.toString();
    }

    private final String makeCleanup(SystemEnvironment systemEnvironment, Vector vector, Vector vector2, HashMap hashMap, Boolean bl) throws SDMSException {
        int n;
        String string = "\ncleanup ";
        String string2 = "";
        for (int i = 0; i < vector.size(); ++i) {
            ObjectURL objectURL = (ObjectURL)vector.get(i);
            if (objectURL.objType != 6) continue;
            SDMSFolder sDMSFolder = (SDMSFolder)objectURL.resolve(systemEnvironment);
            string = string + string2 + DumpF.getDumpedURL(systemEnvironment, sDMSFolder, hashMap);
            string2 = ",\n\t";
        }
        string = string + "\nwith keep = (\n\t";
        Object[] objectArray = new String[vector2.size()];
        string2 = "";
        for (n = 0; n < vector2.size(); ++n) {
            objectArray[n] = vector2.get(n).toString();
        }
        Arrays.sort(objectArray);
        for (n = 0; n < vector2.size(); ++n) {
            string = string + string2 + (String)objectArray[n];
            string2 = ",\n\t";
        }
        string = string + "\n)" + (bl != false ? ",\n\tforce" : "") + ";\n\n";
        return string;
    }

    private final void makeMapping(SystemEnvironment systemEnvironment, HashMap hashMap, WithHash withHash) throws SDMSException {
        if (withHash == null) {
            return;
        }
        for (WithItem withItem : withHash.keySet()) {
            String string = (String)withHash.get(withItem);
            HashMap<Comparable, Object> hashMap2 = (HashMap<Comparable, Object>)hashMap.get(string);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Comparable, Object>();
            }
            hashMap2.put(withItem.key, withItem.value);
            hashMap.put(string, hashMap2);
        }
    }

    @Override
    public final void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SystemEnvironment.getCompatLevel(false);
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector<DumpLine> vector2 = new Vector<DumpLine>();
        Vector vector3 = new Vector();
        vector.add("TEXT");
        vector.add("FILENAME");
        systemEnvironment.checkFeatureAvailability("DUMP_COMMAND");
        Vector<String> vector4 = new Vector<String>();
        HashMap hashMap = new HashMap();
        this.makeMapping(systemEnvironment, hashMap, (WithHash)this.with.get("MAP"));
        Boolean bl = (Boolean)this.with.get("IGNORE");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        int n = SystemEnvironment.checkLangLevel((String)this.with.get("LANGUAGE"));
        String string = (String)this.with.get("MODE");
        int n2 = 2;
        if (string != null && string.equals("DEPLOY")) {
            n2 = 1;
        }
        if (this.with.containsKey("MAP") || this.with.containsKey("CLEANUP") || n2 == 1) {
            systemEnvironment.checkFeatureAvailability("EXTENDED_DUMP_COMMAND");
        }
        HashSet hashSet = this.collectObjectsToDump(systemEnvironment, this.dumpList, this.expandRules, bl);
        Vector vector5 = this.compressAndSort(hashSet);
        for (DumpObject dumpObject : vector5) {
            dumpObject.dump(systemEnvironment, vector2, vector3, hashMap, n2, n);
        }
        if (this.with.containsKey("MULTICOMMAND")) {
            vector2.add(new DumpLine(1, "begin multicommand\n\n"));
            vector2.add(new DumpLine(99, "end multicommand /* rollback */;\n\n"));
        }
        if (this.with.containsKey("HEADER")) {
            vector2.add(new DumpLine(0, (String)this.with.get("HEADER") + "\n\n"));
        }
        if (this.with.containsKey("CLEANUP")) {
            vector2.add(new DumpLine(98, this.makeCleanup(systemEnvironment, this.dumpList, vector3, hashMap, (Boolean)this.with.get("CLEANUP"))));
        }
        vector4.add(this.makeOutput(vector2));
        vector4.add(this.filename);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Dump", vector, vector4);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03704301427", "Dump completed"));
    }

    public final HashSet collectObjectsToDump(SystemEnvironment systemEnvironment, Vector vector, Vector vector2, Boolean bl) throws SDMSException {
        HashSet<DumpObject> hashSet = new HashSet<DumpObject>();
        HashSet hashSet2 = new HashSet();
        boolean bl2 = bl;
        Vector vector3 = this.convertUrlToDO(systemEnvironment, vector, bl2);
        while (vector3.size() != 0) {
            for (int i = 0; i < vector3.size(); ++i) {
                DumpObject dumpObject = (DumpObject)vector3.get(i);
                if (!hashSet.add(dumpObject) || vector2 == null) continue;
                hashSet2.addAll(this.expand(systemEnvironment, dumpObject, vector2, hashSet, bl2));
            }
            vector3 = new Vector();
            vector3.addAll(hashSet2);
            hashSet2 = new HashSet();
        }
        return hashSet;
    }

    protected final Vector expand(SystemEnvironment systemEnvironment, DumpObject dumpObject, Vector vector, HashSet hashSet, boolean bl) throws SDMSException {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            DumpExpandItem dumpExpandItem = (DumpExpandItem)vector.get(i);
            if (dumpExpandItem.type != dumpObject.parserType && dumpExpandItem.type != 99 || !(dumpExpandItem.alias == null && dumpObject.alias == null || dumpExpandItem.alias != null && dumpExpandItem.alias.equals(dumpObject.alias)) && (dumpExpandItem.alias == null || !dumpExpandItem.alias.equals("*"))) continue;
            for (int j = 0; j < dumpExpandItem.ruleList.size(); ++j) {
                DumpRule dumpRule = (DumpRule)dumpExpandItem.ruleList.get(j);
                if (dumpRule.operator == null) continue;
                vector2.addAll(dumpRule.operator.expand(systemEnvironment, dumpObject, hashSet, dumpRule.alias, bl));
            }
        }
        return vector2;
    }

    protected final Vector compressAndSort(HashSet hashSet) {
        Vector<DumpObject> vector = new Vector<DumpObject>();
        Object[] objectArray = hashSet.toArray();
        Arrays.sort(objectArray);
        long l = -1L;
        for (int i = 0; i < objectArray.length; ++i) {
            DumpObject dumpObject = (DumpObject)objectArray[i];
            long l2 = dumpObject.id;
            if (l2 != l) {
                vector.add(dumpObject);
            }
            l = l2;
        }
        return vector;
    }

    protected final Vector convertUrlToDO(SystemEnvironment systemEnvironment, Vector vector, boolean bl) throws SDMSException {
        PathVector pathVector = new PathVector();
        if (vector == null) {
            return this.getAllObjects(systemEnvironment, bl);
        }
        for (int i = 0; i < vector.size(); ++i) {
            ObjectURL objectURL = (ObjectURL)vector.get(i);
            SDMSProxy sDMSProxy = objectURL.resolve(systemEnvironment);
            if (sDMSProxy == null) {
                pathVector.addAll(this.expandAllOperator(systemEnvironment, objectURL, bl));
                continue;
            }
            DumpObject dumpObject = new DumpObject(sDMSProxy.getId(systemEnvironment), null, sDMSProxy, objectURL.objType);
            pathVector.addElement(dumpObject);
        }
        return pathVector;
    }

    protected final Vector expandAllOperator(SystemEnvironment systemEnvironment, ObjectURL objectURL, boolean bl) throws SDMSException {
        switch (objectURL.objType) {
            case 25: {
                return new NoneDistribution().expand(systemEnvironment, bl);
            }
            case 1: {
                return new NoneEnvironment().expand(systemEnvironment, bl);
            }
            case 18: {
                return new NoneEvent().expand(systemEnvironment, bl);
            }
            case 2: {
                return new NoneExitStateDefinition().expand(systemEnvironment, bl);
            }
            case 3: {
                return new NoneExitStateProfile().expand(systemEnvironment, bl);
            }
            case 4: {
                return new NoneExitStateMapping().expand(systemEnvironment, bl);
            }
            case 5: {
                return new NoneExitStateTranslation().expand(systemEnvironment, bl);
            }
            case 6: {
                return new NoneFolder().expand(systemEnvironment, bl);
            }
            case 7: {
                return new NoneFootprint().expand(systemEnvironment, bl);
            }
            case 21: {
                return new NoneGroup().expand(systemEnvironment, bl);
            }
            case 19: {
                return new NoneInterval().expand(systemEnvironment, bl);
            }
            case 9: {
                return new NoneSchedulingEntity().expand(systemEnvironment, bl);
            }
            case 10: {
                return new NoneNamedResource().expand(systemEnvironment, bl);
            }
            case 31: {
                return new NoneNiceProfile().expand(systemEnvironment, bl);
            }
            case 30: {
                return new NoneObjectMonitor().expand(systemEnvironment, bl);
            }
            case 24: {
                return new NonePool().expand(systemEnvironment, bl);
            }
            case 11: {
                return new NoneResource().expand(systemEnvironment, bl);
            }
            case 28: {
                return new NoneResourceTemplate().expand(systemEnvironment, bl);
            }
            case 13: {
                return new NoneResourceStateDefinition().expand(systemEnvironment, bl);
            }
            case 14: {
                return new NoneResourceStateProfile().expand(systemEnvironment, bl);
            }
            case 12: {
                return new NoneResourceStateMapping().expand(systemEnvironment, bl);
            }
            case 20: {
                return new NoneSchedule().expand(systemEnvironment, bl);
            }
            case 22: {
                return new NoneScheduledEvent().expand(systemEnvironment, bl);
            }
            case 15: {
                return new NoneScope().expand(systemEnvironment, bl);
            }
            case 16: {
                return new NoneTrigger().expand(systemEnvironment, bl);
            }
            case 8: {
                return new NoneUser().expand(systemEnvironment, bl);
            }
            case 26: {
                return new NoneComment().expand(systemEnvironment, bl);
            }
            case 27: {
                return new NoneGrant().expand(systemEnvironment, bl);
            }
            case 29: {
                return new NoneWatchType().expand(systemEnvironment, bl);
            }
        }
        return null;
    }

    protected final Vector getAllObjects(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        Vector vector = new Vector();
        vector.addAll(new NoneDistribution().expand(systemEnvironment, bl));
        vector.addAll(new NoneEnvironment().expand(systemEnvironment, bl));
        vector.addAll(new NoneEvent().expand(systemEnvironment, bl));
        vector.addAll(new NoneExitStateDefinition().expand(systemEnvironment, bl));
        vector.addAll(new NoneExitStateProfile().expand(systemEnvironment, bl));
        vector.addAll(new NoneExitStateMapping().expand(systemEnvironment, bl));
        vector.addAll(new NoneExitStateTranslation().expand(systemEnvironment, bl));
        vector.addAll(new NoneFolder().expand(systemEnvironment, bl));
        vector.addAll(new NoneFootprint().expand(systemEnvironment, bl));
        vector.addAll(new NoneGroup().expand(systemEnvironment, bl));
        vector.addAll(new NoneInterval().expand(systemEnvironment, bl));
        vector.addAll(new NoneSchedulingEntity().expand(systemEnvironment, bl));
        vector.addAll(new NoneNamedResource().expand(systemEnvironment, bl));
        vector.addAll(new NoneNiceProfile().expand(systemEnvironment, bl));
        vector.addAll(new NoneObjectMonitor().expand(systemEnvironment, bl));
        vector.addAll(new NonePool().expand(systemEnvironment, bl));
        vector.addAll(new NoneResource().expand(systemEnvironment, bl));
        vector.addAll(new NoneResourceTemplate().expand(systemEnvironment, bl));
        vector.addAll(new NoneResourceStateDefinition().expand(systemEnvironment, bl));
        vector.addAll(new NoneResourceStateProfile().expand(systemEnvironment, bl));
        vector.addAll(new NoneResourceStateMapping().expand(systemEnvironment, bl));
        vector.addAll(new NoneSchedule().expand(systemEnvironment, bl));
        vector.addAll(new NoneScheduledEvent().expand(systemEnvironment, bl));
        vector.addAll(new NoneScope().expand(systemEnvironment, bl));
        vector.addAll(new NoneTrigger().expand(systemEnvironment, bl));
        vector.addAll(new NoneUser().expand(systemEnvironment, bl));
        vector.addAll(new NoneComment().expand(systemEnvironment, bl));
        vector.addAll(new NoneGrant().expand(systemEnvironment, bl));
        vector.addAll(new NoneWatchType().expand(systemEnvironment, bl));
        return vector;
    }
}

