/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectFilter;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.timer.TimerDate;
import de.independit.scheduler.server.timer.TimerUnit;
import de.independit.scheduler.server.util.DateTime;
import de.independit.scheduler.server.util.PathVector;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;

public class ListScheduledEvent
extends Node {
    public static final String __version = "@(#) $Id: ListScheduledEvent.java,v 2.11.8.2 2013/06/18 09:49:34 ronald Exp $";
    private static final String empty = "";
    private DateTime starttime = null;
    private DateTime endtime = null;
    private TimeZone tz = null;
    private ObjectFilter objFilter = new ObjectFilter();
    private WithHash with;
    private Vector filter;

    public ListScheduledEvent() {
        this.txMode = 1;
        this.auditFlag = false;
        this.with = null;
    }

    public ListScheduledEvent(WithHash withHash) {
        this.txMode = 1;
        this.auditFlag = false;
        this.with = withHash;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.with == null) {
            this.plaingo(systemEnvironment);
        } else {
            this.scheduledGo(systemEnvironment);
        }
    }

    public void plaingo(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("OWNER");
        vector.add("SCHEDULE");
        vector.add("EVENT");
        vector.add("ACTIVE");
        vector.add("EFF_ACTIVE");
        vector.add("BROKEN");
        vector.add("ERROR_CODE");
        vector.add("ERROR_MSG");
        vector.add("LAST_START");
        vector.add("NEXT_START");
        vector.add("NEXT_CALC");
        vector.add("PRIVS");
        vector.add("BACKLOG_HANDLING");
        vector.add("SUSPEND_LIMIT");
        vector.add("EFFECTIVE_SUSPEND_LIMIT");
        vector.add("CALENDAR");
        vector.add("CALENDAR_HORIZON");
        vector.add("EFFECTIVE_CALENDAR_HORIZON");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Scheduled Events", vector);
        Iterator iterator = SDMSScheduledEventTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)iterator.next();
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(sDMSScheduledEvent.getId(systemEnvironment));
            Long l = sDMSScheduledEvent.getOwnerId(systemEnvironment);
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
            vector2.add(sDMSGroup.getName(systemEnvironment));
            Long l2 = sDMSScheduledEvent.getSceId(systemEnvironment);
            SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l2);
            vector2.add(sDMSSchedule.pathVector(systemEnvironment));
            Long l3 = sDMSScheduledEvent.getEvtId(systemEnvironment);
            SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l3);
            vector2.add(sDMSEvent.getName(systemEnvironment));
            vector2.add(sDMSScheduledEvent.getIsActive(systemEnvironment));
            vector2.add(sDMSScheduledEvent.isReallyActive(systemEnvironment));
            vector2.add(sDMSScheduledEvent.getIsBroken(systemEnvironment));
            String string = sDMSScheduledEvent.getErrorCode(systemEnvironment);
            if (string == null) {
                vector2.add(empty);
            } else {
                vector2.add(string);
            }
            String string2 = sDMSScheduledEvent.getErrorMsg(systemEnvironment);
            if (string2 == null) {
                vector2.add(empty);
            } else {
                vector2.add(string2);
            }
            Long l4 = sDMSScheduledEvent.getLastStartTime(systemEnvironment);
            if (l4 == null) {
                vector2.add(empty);
            } else {
                vector2.add(new DateTime(l4).toString());
            }
            Long l5 = sDMSScheduledEvent.getNextActivityTime(systemEnvironment);
            if (l5 == null) {
                vector2.add(empty);
                vector2.add(empty);
            } else {
                boolean bl = sDMSScheduledEvent.getNextActivityIsTrigger(systemEnvironment);
                if (bl) {
                    vector2.add(new DateTime(l5).toString());
                    vector2.add(empty);
                } else {
                    vector2.add(empty);
                    vector2.add(new DateTime(l5).toString());
                }
            }
            vector2.add(sDMSScheduledEvent.getPrivileges(systemEnvironment).toString());
            vector2.add(sDMSScheduledEvent.getBacklogHandlingAsString(systemEnvironment));
            TimerUnit timerUnit = new TimerUnit(sDMSScheduledEvent.getSuspendLimitMultiplier(systemEnvironment), sDMSScheduledEvent.getSuspendLimit(systemEnvironment));
            if (timerUnit.isINF()) {
                vector2.add(empty);
            } else {
                vector2.add(timerUnit.asString());
            }
            vector2.add(sDMSScheduledEvent.getEffectiveSuspendLimit(systemEnvironment).asString());
            Boolean bl = sDMSScheduledEvent.getIsCalendar(systemEnvironment);
            vector2.add(sDMSScheduledEvent.getIsCalendarAsString(systemEnvironment));
            if (bl.booleanValue()) {
                Integer n = sDMSScheduledEvent.getCalendarHorizon(systemEnvironment);
                vector2.add(n == null ? empty : n);
                vector2.add(sDMSScheduledEvent.getEffectiveCalendarHorizon(systemEnvironment));
            } else {
                vector2.add(empty);
                vector2.add(empty);
            }
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2, 3));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207261919", "$1 Scheduled Event(s) found", sDMSOutputContainer.lines));
    }

    public void scheduledGo(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("SE_NAME");
        vector.add("SE_TYPE");
        vector.add("SE_ID");
        vector.add("SE_OWNER");
        vector.add("SE_PRIVS");
        vector.add("SCE_NAME");
        vector.add("SCE_ACTIVE");
        vector.add("EVT_NAME");
        vector.add("STARTTIME_GMT");
        vector.add("STARTTIME");
        vector.add("EXPECTED_FINAL_TIME");
        vector.add("TIME_ZONE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of scheduled submits", vector);
        if (!this.with.containsKey("STARTTIME")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209051439", "Syntax Error: Start time is missing"));
        }
        this.starttime = (DateTime)this.with.get("STARTTIME");
        this.starttime.suppressSeconds();
        this.starttime.fixToMinDate();
        if (!this.with.containsKey("ENDTIME")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209051440", "Syntax Error: End time is missing"));
        }
        this.endtime = (DateTime)this.with.get("ENDTIME");
        this.starttime.suppressSeconds();
        this.endtime.fixToMinDate();
        this.tz = this.with.containsKey("TIME") ? TimeZone.getTimeZone((String)this.with.get("TIME")) : TimeZone.getDefault();
        this.filter = this.with.containsKey("FILTER") ? this.objFilter.initialize_filter(systemEnvironment, (Vector)this.with.get("FILTER"), 0, true) : new Vector();
        TimerDate timerDate = new TimerDate(this.endtime.getTimeInMillis() / 60000L);
        System.out.println("TimerDate finalDate = " + timerDate.toString());
        Iterator iterator = SDMSScheduledEventTable.table.iterator(systemEnvironment);
        block0: while (iterator.hasNext()) {
            SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)iterator.next();
            Long l = sDMSScheduledEvent.getId(systemEnvironment);
            Long l2 = sDMSScheduledEvent.getSceId(systemEnvironment);
            SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l2);
            PathVector pathVector = sDMSSchedule.pathVector(systemEnvironment);
            Boolean bl = sDMSSchedule.getIsActive(systemEnvironment);
            TimeZone timeZone = TimeZone.getTimeZone(sDMSSchedule.getTimeZone(systemEnvironment));
            Long l3 = sDMSScheduledEvent.getEvtId(systemEnvironment);
            SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l3);
            String string = sDMSEvent.getName(systemEnvironment);
            Long l4 = sDMSEvent.getSeId(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l4);
            if (!this.objFilter.doFilter(systemEnvironment, sDMSSchedulingEntity, this.filter)) continue;
            PathVector pathVector2 = sDMSSchedulingEntity.pathVector(systemEnvironment);
            String string2 = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
            Long l5 = sDMSSchedulingEntity.getOwnerId(systemEnvironment);
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l5);
            String string3 = sDMSGroup.getName(systemEnvironment);
            String string4 = sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString();
            Integer n = sDMSSchedulingEntity.getExpectedFinaltime(systemEnvironment);
            String string5 = n == null ? empty : n.toString();
            GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
            TimeZone timeZone2 = SystemEnvironment.systemTimeZone;
            String string6 = timeZone.getID();
            TimerDate timerDate2 = new TimerDate(this.starttime.getTimeInMillis() / 60000L);
            TimerDate timerDate3 = new TimerDate(timerDate2);
            int n2 = 0;
            int n3 = SystemEnvironment.maxNumCalEntries;
            do {
                Vector<Object> vector2 = new Vector<Object>();
                timerDate2 = sDMSSchedule.getNextTriggerDate(systemEnvironment, timerDate3);
                if (timerDate2 == null || timerDate2.isNaD()) continue block0;
                gregorianCalendar.setTimeZone(timeZone2);
                gregorianCalendar.setTimeInMillis(timerDate2.getTime());
                gregorianCalendar.setTimeZone(timeZone);
                TimerDate timerDate4 = new TimerDate(gregorianCalendar.getTimeInMillis() / 60000L);
                if (timerDate2.lt(timerDate)) {
                    vector2.add(l);
                    vector2.add(pathVector2);
                    vector2.add(string2);
                    vector2.add(l4);
                    vector2.add(string3);
                    vector2.add(string4);
                    vector2.add(pathVector);
                    vector2.add(bl);
                    vector2.add(string);
                    vector2.add(timerDate4);
                    vector2.add(timerDate4.toString(timeZone));
                    vector2.add(string5);
                    vector2.add(string6);
                    ++n2;
                    sDMSOutputContainer.addData(systemEnvironment, vector2);
                }
                timerDate3.set(timerDate2.plus(1));
            } while (timerDate3.le(timerDate) && n2 < n3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 10, 2));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207261919", "$1 Scheduled Event(s) found", sDMSOutputContainer.lines));
    }
}

