/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.IntervalReference;
import de.independit.scheduler.server.repository.RefererType;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalSelection;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.timer.TimerDate;
import de.independit.scheduler.server.timer.TimerUnit;
import de.independit.scheduler.server.util.DateTime;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class ShowInterval
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowInterval.java,v 2.10.2.2 2013/06/18 09:49:36 ronald Exp $";
    private static final TimeZone localTimeZone = SystemEnvironment.systemTimeZone;
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm", SystemEnvironment.systemLocale);
    private static final String empty = "";
    private static final String ROLE_HEAD = "HEAD";
    private static final String ROLE_FILTER = "FILTER";
    private static final String ROLE_EMBED = "EMBEDDED";
    private static final String ROLE_DISPATCH = "DISPATCH";
    private static final String ROLE_DISP_SELECT = "DISPATCH_SELECT";
    private static final String ROLE_DISP_FILTER = "DISPATCH_FILTER";
    private static final int[] cmpList = new int[]{1, 2, 3};
    private String name;
    private Long intId;
    private final Long ownerObject;
    private final Vector edgesFromTo;
    private final TimerDate edgePlusOne = new TimerDate();
    private boolean secondsIgnore;
    private double seconds = 0.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String toString(TimerDate timerDate, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = df;
        synchronized (simpleDateFormat) {
            df.setTimeZone(timeZone);
            return df.format(timerDate) + " " + timeZone.getID();
        }
    }

    public ShowInterval(String string, Long l, Vector vector) {
        this.name = string;
        this.intId = null;
        this.ownerObject = l;
        this.txMode = 1;
        this.auditFlag = false;
        this.edgesFromTo = vector;
    }

    public ShowInterval(Long l, Long l2, Vector vector) {
        this.name = null;
        this.intId = l;
        this.ownerObject = l2;
        this.txMode = 1;
        this.auditFlag = false;
        this.edgesFromTo = vector;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        SDMSInterval sDMSInterval = this.name != null ? SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.name), this.ownerObject)) : SDMSIntervalTable.getObject(systemEnvironment, this.intId);
        if (!sDMSInterval.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411717", "Insufficient privileges"));
        }
        Long l = sDMSInterval.getId(systemEnvironment);
        long l2 = System.currentTimeMillis();
        long l3 = System.currentTimeMillis();
        this.seconds = (double)(l3 - l2) / 1000.0;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("STARTTIME");
        vector.add("ENDTIME");
        vector.add("BASE");
        vector.add("DURATION");
        vector.add("SYNCTIME");
        vector.add("INVERSE");
        vector.add(ROLE_EMBED);
        vector.add("SELECTION");
        vector.add(ROLE_FILTER);
        vector.add("DISPATCHER");
        vector.add("HIERARCHY");
        vector.add("REFERENCES");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("OWNER_OBJ_TYPE");
        vector.add("OWNER_OBJ_ID");
        vector.add("SE_ID");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        if (this.edgesFromTo != null) {
            vector.add("EDGES");
        }
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSInterval.getName(systemEnvironment));
        Long l4 = sDMSInterval.getOwnerId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l4);
        vector2.add(sDMSGroup.getName(systemEnvironment));
        Long l5 = sDMSInterval.getStartTime(systemEnvironment);
        if (l5 == null) {
            vector2.add(empty);
        } else {
            vector2.add(new DateTime(l5, false).toString(null));
        }
        Long l6 = sDMSInterval.getEndTime(systemEnvironment);
        if (l6 == null) {
            vector2.add(empty);
        } else {
            vector2.add(new DateTime(l6, false).toString(null));
        }
        TimerUnit timerUnit = new TimerUnit(sDMSInterval.getBaseIntervalMultiplier(systemEnvironment), sDMSInterval.getBaseInterval(systemEnvironment));
        if (timerUnit.isINF()) {
            vector2.add(empty);
        } else {
            vector2.add(timerUnit.asString());
        }
        TimerUnit timerUnit2 = new TimerUnit(sDMSInterval.getDurationMultiplier(systemEnvironment), sDMSInterval.getDuration(systemEnvironment));
        if (timerUnit2.isINF()) {
            vector2.add(empty);
        } else {
            vector2.add(timerUnit2.asString());
        }
        vector2.add(new DateTime(sDMSInterval.getSyncTime(systemEnvironment), false).toString(null));
        vector2.add(sDMSInterval.getIsInverse(systemEnvironment));
        Long l7 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
        if (l7 == null) {
            vector2.add(empty);
        } else {
            comparable = SDMSIntervalTable.getObject(systemEnvironment, l7);
            vector2.add(((SDMSIntervalProxyGeneric)comparable).getName(systemEnvironment));
        }
        vector2.add(this.getSelectionList(systemEnvironment, l));
        vector2.add(this.getFilterList(systemEnvironment, l));
        vector2.add(this.getDispatcherList(systemEnvironment, l));
        vector2.add(this.getHierarchyList(systemEnvironment, l));
        vector2.add(this.getReferences(systemEnvironment, sDMSInterval));
        this.secondsIgnore = false;
        comparable = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSInterval.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(sDMSInterval.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSInterval.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(sDMSInterval.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        vector2.add(sDMSInterval.getPrivileges(systemEnvironment).toString());
        vector2.add(sDMSInterval.getObjTypeAsString(systemEnvironment));
        vector2.add(sDMSInterval.getObjId(systemEnvironment));
        vector2.add(sDMSInterval.getSeId(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        if (this.edgesFromTo != null) {
            vector2.add(this.getEdgesList(systemEnvironment, sDMSInterval));
        }
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Interval", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        if (this.secondsIgnore) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04305012013", "Interval shown (WARNING: seconds will be ignored)"));
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207192249", "Interval shown"));
        }
    }

    private SDMSOutputContainer getSelectionList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("VALUE");
        vector.add("PERIOD_FROM");
        vector.add("PERIOD_TO");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Interval Selections", vector);
        Vector vector2 = SDMSIntervalSelectionTable.idx_intId.getVector(systemEnvironment, l);
        for (SDMSIntervalSelection sDMSIntervalSelection : vector2) {
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSIntervalSelection.getId(systemEnvironment));
            Integer n = sDMSIntervalSelection.getValue(systemEnvironment);
            if (n == null) {
                vector3.add(empty);
            } else {
                vector3.add(n);
            }
            Long l2 = sDMSIntervalSelection.getPeriodFrom(systemEnvironment);
            if (l2 == null) {
                vector3.add(empty);
            } else {
                vector3.add(new DateTime(l2, false).toString(null));
            }
            Long l3 = sDMSIntervalSelection.getPeriodTo(systemEnvironment);
            if (l3 == null) {
                vector3.add(empty);
            } else {
                vector3.add(new DateTime(l3, false).toString(null));
            }
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 0));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getFilterList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("CHILD");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Interval Filters", vector);
        Vector vector2 = SDMSIntervalHierarchyTable.idx_parentId.getVector(systemEnvironment, l);
        for (SDMSIntervalHierarchy sDMSIntervalHierarchy : vector2) {
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSIntervalHierarchy.getId(systemEnvironment));
            Long l2 = sDMSIntervalHierarchy.getChildId(systemEnvironment);
            SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l2);
            vector3.add(sDMSInterval.getName(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getDispatcherList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("SEQNO");
        vector.add("NAME");
        vector.add("SELECT_INTERVAL_ID");
        vector.add("SELECT_INTERVAL_NAME");
        vector.add("FILTER_INTERVAL_ID");
        vector.add("FILTER_INTERVAL_NAME");
        vector.add("IS_ENABLED");
        vector.add("IS_ACTIVE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Dispatch Rules", vector);
        Vector vector2 = SDMSIntervalDispatcherTable.idx_intId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            Comparable comparable;
            SDMSIntervalDispatcher sDMSIntervalDispatcher = (SDMSIntervalDispatcher)vector2.get(i);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSIntervalDispatcher.getId(systemEnvironment));
            vector3.add(sDMSIntervalDispatcher.getSeqNo(systemEnvironment));
            vector3.add(sDMSIntervalDispatcher.getName(systemEnvironment));
            Long l2 = sDMSIntervalDispatcher.getSelectIntId(systemEnvironment);
            vector3.add(l2);
            if (l2 != null) {
                comparable = SDMSIntervalTable.getObject(systemEnvironment, l2);
                vector3.add(comparable.getName(systemEnvironment));
            } else {
                vector3.add(null);
            }
            comparable = sDMSIntervalDispatcher.getFilterIntId(systemEnvironment);
            vector3.add(comparable);
            if (comparable != null) {
                SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, (Long)comparable);
                vector3.add(sDMSInterval.getName(systemEnvironment));
            } else {
                vector3.add(null);
            }
            vector3.add(sDMSIntervalDispatcher.getIsEnabled(systemEnvironment));
            vector3.add(sDMSIntervalDispatcher.getIsActive(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getReferences(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("REFERER_ID");
        vector.add("REFERER_NAME");
        vector.add("REFERER_TYPE");
        vector.add("REFERENCE_TYPE");
        vector.add("CHILD_ID");
        vector.add("CHILD_NAME");
        vector.add("CHILD_TYPE");
        vector.add("REFERENCE_PATH");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Interval References", vector);
        Vector vector2 = sDMSInterval.collectReferences(systemEnvironment, 0);
        for (int i = 0; i < vector2.size(); ++i) {
            Vector vector3 = (Vector)vector2.get(i);
            int n = vector3.size() - 1;
            IntervalReference intervalReference = (IntervalReference)vector3.get(n);
            Vector<Object> vector4 = new Vector<Object>();
            vector4.add(intervalReference.refererId);
            vector4.add(intervalReference.refererName);
            if (intervalReference.refererType == RefererType.SCHEDULING_ENTITY) {
                vector4.add(intervalReference.seType);
            } else {
                vector4.add(sDMSInterval.refererTypeToString(intervalReference.refererType));
            }
            vector4.add(sDMSInterval.referenceUsageToString(intervalReference.referenceUsage));
            vector4.add(intervalReference.childId);
            vector4.add(intervalReference.childName);
            vector4.add(intervalReference.childType);
            String string = empty;
            String string2 = empty;
            for (int j = 0; j < n; ++j) {
                IntervalReference intervalReference2 = (IntervalReference)vector3.get(j);
                string = intervalReference2.refererName + string2 + string;
                string2 = ".";
            }
            vector4.add(string);
            sDMSOutputContainer.addData(systemEnvironment, vector4);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getHierarchyList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("LEVEL");
        vector.add("ROLE");
        vector.add("PARENT");
        vector.add("NAME");
        vector.add("SEQNO");
        vector.add("SELECT_INTERVAL_NAME");
        vector.add("FILTER_INTERVAL_NAME");
        vector.add("IS_ENABLED");
        vector.add("IS_ACTIVE");
        vector.add("OWNER");
        vector.add("STARTTIME");
        vector.add("ENDTIME");
        vector.add("BASE");
        vector.add("DURATION");
        vector.add("SYNCTIME");
        vector.add("INVERSE");
        vector.add(ROLE_EMBED);
        vector.add("SELECTION");
        vector.add(ROLE_FILTER);
        vector.add("DISPATCHER");
        vector.add("OWNER_OBJ_TYPE");
        vector.add("OWNER_OBJ_ID");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Interval Hierarchy", vector);
        this.collectHierarchy(systemEnvironment, l, ROLE_HEAD, null, sDMSOutputContainer, 0);
        return sDMSOutputContainer;
    }

    private void collectHierarchy(SystemEnvironment systemEnvironment, Long l, String string, Long l2, SDMSOutputContainer sDMSOutputContainer, int n) throws SDMSException {
        Comparable comparable;
        Comparable<Long> comparable2;
        Object object;
        Comparable<Long> comparable3;
        Object object2;
        Object object32;
        SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l);
        SDMSInterval sDMSInterval2 = null;
        Integer n2 = n;
        Vector<Object> vector = new Vector<Object>();
        vector.add(l);
        vector.add(n2);
        vector.add(string);
        vector.add(l2);
        vector.add(sDMSInterval.getName(systemEnvironment));
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        Long l3 = sDMSInterval.getOwnerId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l3);
        vector.add(sDMSGroup.getName(systemEnvironment));
        Long l4 = sDMSInterval.getStartTime(systemEnvironment);
        if (l4 == null) {
            vector.add(empty);
        } else {
            vector.add(new DateTime(l4, false).toString(null));
        }
        Long l5 = sDMSInterval.getEndTime(systemEnvironment);
        if (l5 == null) {
            vector.add(empty);
        } else {
            vector.add(new DateTime(l5, false).toString(null));
        }
        TimerUnit timerUnit = new TimerUnit(sDMSInterval.getBaseIntervalMultiplier(systemEnvironment), sDMSInterval.getBaseInterval(systemEnvironment));
        if (timerUnit.isINF()) {
            vector.add(empty);
        } else {
            vector.add(timerUnit.asString());
        }
        TimerUnit timerUnit2 = new TimerUnit(sDMSInterval.getDurationMultiplier(systemEnvironment), sDMSInterval.getDuration(systemEnvironment));
        if (timerUnit2.isINF()) {
            vector.add(empty);
        } else {
            vector.add(timerUnit2.asString());
        }
        vector.add(new DateTime(sDMSInterval.getSyncTime(systemEnvironment), false).toString(null));
        vector.add(sDMSInterval.getIsInverse(systemEnvironment));
        Long l6 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
        if (l6 == null) {
            vector.add(empty);
        } else {
            sDMSInterval2 = SDMSIntervalTable.getObject(systemEnvironment, l6);
            vector.add(sDMSInterval2.getName(systemEnvironment));
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = empty;
        Vector vector2 = SDMSIntervalSelectionTable.idx_intId.getVector(systemEnvironment, l);
        for (Object object32 : vector2) {
            object2 = ((SDMSIntervalSelectionProxyGeneric)object32).getValue(systemEnvironment);
            if (object2 != null) {
                stringBuffer.append(string2);
                stringBuffer.append(object2);
            }
            if ((comparable3 = ((SDMSIntervalSelectionProxyGeneric)object32).getPeriodFrom(systemEnvironment)) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(new DateTime((Long)comparable3, false).toString(null));
            }
            if ((object = ((SDMSIntervalSelectionProxyGeneric)object32).getPeriodTo(systemEnvironment)) != null) {
                if (comparable3 != null) {
                    stringBuffer.append(" - ");
                } else {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(new DateTime((Long)object, false).toString(null));
            }
            string2 = ", ";
        }
        vector.add(stringBuffer.toString());
        object32 = SDMSIntervalHierarchyTable.idx_parentId.getVector(systemEnvironment, l);
        object2 = ((Vector)object32).iterator();
        comparable3 = new StringBuffer();
        string2 = empty;
        while (object2.hasNext()) {
            object = (SDMSIntervalHierarchy)object2.next();
            comparable2 = ((SDMSIntervalHierarchyProxyGeneric)object).getChildId(systemEnvironment);
            SDMSInterval sDMSInterval3 = SDMSIntervalTable.getObject(systemEnvironment, (Long)comparable2);
            ((StringBuffer)comparable3).append(string2);
            ((StringBuffer)comparable3).append(sDMSInterval3.getName(systemEnvironment));
            string2 = ", ";
        }
        vector.add(((StringBuffer)comparable3).toString());
        object = SDMSIntervalDispatcherTable.idx_intId.getSortedVector(systemEnvironment, l);
        comparable2 = new StringBuffer();
        string2 = empty;
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            comparable = (SDMSIntervalDispatcher)((Vector)object).get(i);
            ((StringBuffer)comparable2).append(string2);
            ((StringBuffer)comparable2).append(((SDMSIntervalDispatcherProxyGeneric)comparable).getName(systemEnvironment));
            string2 = ", ";
        }
        vector.add(((StringBuffer)comparable2).toString());
        vector.add(sDMSInterval.getObjTypeAsString(systemEnvironment));
        vector.add(sDMSInterval.getObjId(systemEnvironment));
        sDMSOutputContainer.addData(systemEnvironment, vector);
        if (l6 != null) {
            this.collectHierarchy(systemEnvironment, l6, ROLE_EMBED, l, sDMSOutputContainer, n + 1);
        }
        object2 = ((Vector)object32).iterator();
        while (object2.hasNext()) {
            SDMSIntervalHierarchy sDMSIntervalHierarchy = (SDMSIntervalHierarchy)object2.next();
            comparable = sDMSIntervalHierarchy.getChildId(systemEnvironment);
            this.collectHierarchy(systemEnvironment, (Long)comparable, ROLE_FILTER, l, sDMSOutputContainer, n + 1);
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            comparable = (SDMSIntervalDispatcher)((Vector)object).get(i);
            this.collectDspHierarchy(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment), ROLE_DISPATCH, l, sDMSOutputContainer, n + 1);
        }
    }

    private void collectDspHierarchy(SystemEnvironment systemEnvironment, Long l, String string, Long l2, SDMSOutputContainer sDMSOutputContainer, int n) throws SDMSException {
        Comparable comparable;
        SDMSIntervalDispatcher sDMSIntervalDispatcher = SDMSIntervalDispatcherTable.getObject(systemEnvironment, l);
        Vector<Object> vector = new Vector<Object>();
        Integer n2 = n;
        vector.add(l);
        vector.add(n2);
        vector.add(string);
        vector.add(l2);
        vector.add(sDMSIntervalDispatcher.getName(systemEnvironment));
        vector.add(sDMSIntervalDispatcher.getSeqNo(systemEnvironment));
        Long l3 = sDMSIntervalDispatcher.getSelectIntId(systemEnvironment);
        if (l3 != null) {
            comparable = SDMSIntervalTable.getObject(systemEnvironment, l3);
            vector.add(comparable.getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        comparable = sDMSIntervalDispatcher.getFilterIntId(systemEnvironment);
        if (comparable != null) {
            SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, (Long)comparable);
            vector.add(sDMSInterval.getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        vector.add(sDMSIntervalDispatcher.getIsEnabled(systemEnvironment));
        vector.add(sDMSIntervalDispatcher.getIsActive(systemEnvironment));
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        sDMSOutputContainer.addData(systemEnvironment, vector);
        if (l3 != null) {
            this.collectHierarchy(systemEnvironment, l3, ROLE_DISP_SELECT, l, sDMSOutputContainer, n + 1);
        }
        if (comparable != null) {
            this.collectHierarchy(systemEnvironment, (Long)comparable, ROLE_DISP_FILTER, l, sDMSOutputContainer, n + 1);
        }
    }

    private SDMSOutputContainer getEdgesList(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("TRIGGER_DATE");
        vector.add("BLOCK_END");
        int n = 0;
        int n2 = SystemEnvironment.maxNumCalEntries;
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Edges", vector);
        GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
        if (this.edgesFromTo == null) {
            return sDMSOutputContainer;
        }
        DateTime dateTime = (DateTime)this.edgesFromTo.get(0);
        DateTime dateTime2 = (DateTime)this.edgesFromTo.get(1);
        if (this.edgesFromTo.size() > 2) {
            n2 = (Integer)this.edgesFromTo.get(2);
        }
        if (n2 > SystemEnvironment.maxNumCalEntries) {
            n2 = SystemEnvironment.maxNumCalEntries;
        }
        dateTime.suppressSeconds();
        dateTime.fixToMinDate();
        TimerDate timerDate = new TimerDate(dateTime.toDate());
        dateTime2.suppressSeconds();
        dateTime2.fixToMaxDate();
        TimerDate timerDate2 = new TimerDate(dateTime2.toDate());
        gregorianCalendar.setTimeInMillis((long)(timerDate.toMinutes() * 60) * 1000L);
        gregorianCalendar.setTimeZone(localTimeZone);
        long l = gregorianCalendar.getTimeInMillis();
        if (timerDate.ge(timerDate2)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04305011929", "lower limit must not be greater than upper limit"));
        }
        timerDate2.plus(1);
        Long l2 = sDMSInterval.getNextTriggerDate(systemEnvironment, (long)timerDate.toMinutes() * 60L * 1000L, (long)timerDate2.toMinutes() * 60L * 1000L, localTimeZone, false);
        TimerDate timerDate3 = new TimerDate();
        long l3 = (long)timerDate2.toMinutes() * 60L * 1000L;
        while (l2 != null && l2 < l3 && n < n2) {
            Vector<String> vector2 = new Vector<String>();
            l = l2;
            gregorianCalendar.setTimeInMillis(l);
            gregorianCalendar.setTimeZone(localTimeZone);
            timerDate3 = new TimerDate((int)(gregorianCalendar.getTimeInMillis() / 60000L));
            vector2.add(timerDate3.toString(false));
            Long l4 = sDMSInterval.getCurrentBlockEnd(systemEnvironment);
            if (l4 == null) {
                vector2.add(null);
            } else {
                l = l4;
                gregorianCalendar.setTimeInMillis(l);
                gregorianCalendar.setTimeZone(localTimeZone);
                timerDate3 = new TimerDate((int)(gregorianCalendar.getTimeInMillis() / 60000L));
                vector2.add(timerDate3.toString(false));
            }
            sDMSOutputContainer.addData(systemEnvironment, vector2);
            ++n;
            l2 = sDMSInterval.getNextTriggerDate(systemEnvironment, l2 + 1L, l3, localTimeZone, false);
        }
        return sDMSOutputContainer;
    }
}

