/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Date;
import java.util.Vector;

public class ShowResourceStatus
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowResourceStatus.java,v 2.2.8.1 2013/03/14 10:24:50 ronald Exp $";
    String name;

    public ShowResourceStatus(String string) {
        this.txMode = 1;
        this.auditFlag = false;
        this.name = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSResourceStateDefinition sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.name);
        if (!sDMSResourceStateDefinition.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411720", "Insufficient privileges"));
        }
        Long l = sDMSResourceStateDefinition.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSResourceStateDefinition.getName(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSResourceStateDefinition.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSResourceStateDefinition.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSResourceStateDefinition.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSResourceStateDefinition.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSResourceStateDefinition.getPrivileges(systemEnvironment).toString());
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Resource State Definition", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201100044", "Resource State Definition shown"));
    }
}

