/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSCalendarTable;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.timer.TimerUnit;
import de.independit.scheduler.server.util.DateTime;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class ShowScheduledEvent
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowScheduledEvent.java,v 2.15.2.2 2013/06/18 09:49:37 ronald Exp $";
    private final Vector path;
    private final String name;
    private static final String empty = "";
    private GregorianCalendar gc;
    private TimeZone gmtTz;
    private TimeZone tz;

    public ShowScheduledEvent(Vector vector, String string) {
        this.path = vector;
        this.name = string;
        this.txMode = 1;
        this.auditFlag = false;
    }

    public SDMSOutputContainer renderCalendar(SystemEnvironment systemEnvironment, Long l, SDMSSchedule sDMSSchedule) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("STARTTIME");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "CALENDAR_TABLE", vector);
        Vector vector2 = SDMSCalendarTable.idx_scevId.getVector(systemEnvironment, l);
        Comparator comparator = SDMSCalendar.getComparator(systemEnvironment);
        Collections.sort(vector2, comparator);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSCalendar sDMSCalendar = (SDMSCalendar)vector2.get(i);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSCalendar.getId(systemEnvironment));
            Long l2 = sDMSCalendar.getStarttime(systemEnvironment);
            this.gc.setTimeZone(this.gmtTz);
            this.gc.setTimeInMillis(l2 * 1000L);
            this.gc.setTimeZone(this.tz);
            vector3.add(new DateTime(this.gc.getTimeInMillis() / 1000L).toString(this.tz, true));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        return sDMSOutputContainer;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Serializable serializable;
        Long l = SDMSScheduleTable.pathToId(systemEnvironment, this.path);
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l);
        this.gc = SystemEnvironment.newGregorianCalendar();
        this.gmtTz = SystemEnvironment.systemTimeZone;
        this.tz = TimeZone.getTimeZone(sDMSSchedule.getTimeZone(systemEnvironment));
        SDMSEvent sDMSEvent = SDMSEventTable.idx_name_getUnique(systemEnvironment, this.name);
        Long l2 = sDMSEvent.getId(systemEnvironment);
        SDMSKey sDMSKey = new SDMSKey(l, l2);
        SDMSScheduledEvent sDMSScheduledEvent = SDMSScheduledEventTable.idx_sceId_evtId_getUnique(systemEnvironment, sDMSKey);
        if (!sDMSScheduledEvent.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411724", "Insufficient privileges"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("OWNER");
        vector.add("SCHEDULE");
        vector.add("EVENT");
        vector.add("ACTIVE");
        vector.add("EFF_ACTIVE");
        vector.add("BROKEN");
        vector.add("ERROR_CODE");
        vector.add("ERROR_MSG");
        vector.add("LAST_START");
        vector.add("NEXT_START");
        vector.add("NEXT_CALC");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("BACKLOG_HANDLING");
        vector.add("SUSPEND_LIMIT");
        vector.add("EFFECTIVE_SUSPEND_LIMIT");
        vector.add("CALENDAR");
        vector.add("CALENDAR_HORIZON");
        vector.add("EFFECTIVE_CALENDAR_HORIZON");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CALENDAR_TABLE");
        Vector<Object> vector2 = new Vector<Object>();
        Long l3 = sDMSScheduledEvent.getId(systemEnvironment);
        vector2.add(l3);
        Long l4 = sDMSScheduledEvent.getOwnerId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l4);
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(sDMSSchedule.pathVector(systemEnvironment));
        vector2.add(sDMSEvent.getName(systemEnvironment));
        vector2.add(sDMSScheduledEvent.getIsActive(systemEnvironment));
        vector2.add(sDMSScheduledEvent.isReallyActive(systemEnvironment));
        vector2.add(sDMSScheduledEvent.getIsBroken(systemEnvironment));
        String string = sDMSScheduledEvent.getErrorCode(systemEnvironment);
        if (string == null) {
            vector2.add(empty);
        } else {
            vector2.add(string);
        }
        String string2 = sDMSScheduledEvent.getErrorMsg(systemEnvironment);
        if (string2 == null) {
            vector2.add(empty);
        } else {
            vector2.add(string2);
        }
        Long l5 = sDMSScheduledEvent.getLastStartTime(systemEnvironment);
        if (l5 == null) {
            vector2.add(empty);
        } else {
            this.gc.setTimeZone(this.gmtTz);
            this.gc.setTimeInMillis(l5 * 1000L);
            this.gc.setTimeZone(this.tz);
            vector2.add(new DateTime(this.gc.getTimeInMillis() / 1000L).toString(this.tz));
        }
        Long l6 = sDMSScheduledEvent.getNextActivityTime(systemEnvironment);
        if (l6 == null) {
            vector2.add(empty);
            vector2.add(empty);
        } else {
            boolean bl = sDMSScheduledEvent.getNextActivityIsTrigger(systemEnvironment);
            if (bl) {
                this.gc.setTimeZone(this.gmtTz);
                this.gc.setTimeInMillis(l6 * 1000L);
                this.gc.setTimeZone(this.tz);
                vector2.add(new DateTime(this.gc.getTimeInMillis() / 1000L).toString(this.tz));
                vector2.add(empty);
            } else {
                vector2.add(empty);
                this.gc.setTimeZone(this.gmtTz);
                this.gc.setTimeInMillis(l6 * 1000L);
                this.gc.setTimeZone(this.tz);
                vector2.add(new DateTime(this.gc.getTimeInMillis() / 1000L).toString(this.tz));
            }
        }
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSScheduledEvent.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSScheduledEvent.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSScheduledEvent.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSScheduledEvent.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSScheduledEvent.getPrivileges(systemEnvironment).toString());
        vector2.add(sDMSScheduledEvent.getBacklogHandlingAsString(systemEnvironment));
        TimerUnit timerUnit = new TimerUnit(sDMSScheduledEvent.getSuspendLimitMultiplier(systemEnvironment), sDMSScheduledEvent.getSuspendLimit(systemEnvironment));
        if (timerUnit.isINF()) {
            vector2.add(empty);
        } else {
            vector2.add(timerUnit.asString());
        }
        vector2.add(sDMSScheduledEvent.getEffectiveSuspendLimit(systemEnvironment).asString());
        Boolean bl = sDMSScheduledEvent.getIsCalendar(systemEnvironment);
        vector2.add(sDMSScheduledEvent.getIsCalendarAsString(systemEnvironment));
        if (bl.booleanValue()) {
            serializable = sDMSScheduledEvent.getCalendarHorizon(systemEnvironment);
            vector2.add(serializable == null ? empty : serializable);
            vector2.add(sDMSScheduledEvent.getEffectiveCalendarHorizon(systemEnvironment));
        } else {
            vector2.add(empty);
            vector2.add(empty);
        }
        vector2.add(this.getCommentContainer(systemEnvironment, l3));
        vector2.add(this.getCommentInfoType(systemEnvironment, l3));
        vector2.add(this.renderCalendar(systemEnvironment, l3, sDMSSchedule));
        serializable = new SDMSOutputContainer(systemEnvironment, "Scheduled Event", vector, vector2);
        this.result.setOutputContainer((SDMSOutputContainer)serializable);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207262108", "Scheduled Event shown"));
    }
}

