/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.ListenThread;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.UserConnection;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Vector;

public class ShowSession
extends Node {
    public static final String __version = "@(#) $Id: ShowSession.java,v 2.7.8.2 2013/06/18 09:49:38 ronald Exp $";
    private Integer sid;

    public ShowSession(Integer n) {
        this.sid = n;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        vector.add("THIS");
        vector.add("SESSIONID");
        vector.add("START");
        vector.add("USER");
        vector.add("UID");
        vector.add("IP");
        vector.add("IS_SSL");
        vector.add("IS_AUTHENTICATED");
        vector.add("TXID");
        vector.add("IDLE");
        vector.add("TIMEOUT");
        vector.add("STATEMENT");
        ThreadGroup threadGroup = this.env.getMe().getThreadGroup();
        Thread[] threadArray = new SDMSThread[threadGroup.activeCount()];
        int n = threadGroup.enumerate(threadArray);
        if (this.sid == null) {
            this.sid = this.env.id();
        }
        Vector vector3 = new Vector();
        for (int i = 0; i < n; ++i) {
            if (threadArray[i] instanceof ListenThread) continue;
            ConnectionEnvironment connectionEnvironment = ((UserConnection)threadArray[i]).getEnv();
            if (this.sid.intValue() != ((SDMSThread)threadArray[i]).id()) continue;
            this.fillVector(systemEnvironment, connectionEnvironment, vector3);
            sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Session", vector, vector3);
            break;
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112182120", "Session shown"));
        this.result.setOutputContainer(sDMSOutputContainer);
    }

    private void fillVector(SystemEnvironment systemEnvironment, ConnectionEnvironment connectionEnvironment, Vector vector) throws SDMSException {
        if (connectionEnvironment.id() == this.env.id()) {
            vector.add(" * ");
        } else {
            vector.add(" ");
        }
        vector.add(connectionEnvironment.id());
        vector.add(connectionEnvironment.dStart());
        if (connectionEnvironment.isJobServer()) {
            vector.add(SDMSScopeTable.getObject(systemEnvironment, connectionEnvironment.uid()).pathString(systemEnvironment));
        } else {
            vector.add(SDMSUserTable.getObject(systemEnvironment, connectionEnvironment.uid()).getName(systemEnvironment));
        }
        vector.add(connectionEnvironment.uid());
        vector.add(connectionEnvironment.ip());
        vector.add(connectionEnvironment.getIsSSLConnection());
        vector.add(connectionEnvironment.getIsClientAuthenticated());
        vector.add(connectionEnvironment.txId());
        vector.add(connectionEnvironment.idle());
        vector.add(Long.valueOf(connectionEnvironment.timeout()));
        vector.add(new String(connectionEnvironment.actstmt == null ? "" : connectionEnvironment.actstmt));
    }
}

