/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class OwnerFilter
extends Filter {
    HashSet owners = null;
    Vector names;
    SystemEnvironment env;

    public OwnerFilter(SystemEnvironment systemEnvironment, Vector vector) {
        this.names = vector;
        this.env = systemEnvironment;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSOwnedObject sDMSOwnedObject;
            if (this.owners == null) {
                this.fillOwners(systemEnvironment);
            }
            if (sDMSProxy instanceof SDMSCalendar) {
                SDMSScheduledEvent sDMSScheduledEvent = SDMSScheduledEventTable.getObject(systemEnvironment, ((SDMSCalendar)sDMSProxy).getScevId(systemEnvironment));
                SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, sDMSScheduledEvent.getEvtId(systemEnvironment));
                sDMSOwnedObject = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSEvent.getSeId(systemEnvironment));
            } else if (sDMSProxy instanceof SDMSScheduledEvent) {
                SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, ((SDMSScheduledEvent)sDMSProxy).getEvtId(systemEnvironment));
                sDMSOwnedObject = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSEvent.getSeId(systemEnvironment));
            } else {
                sDMSOwnedObject = (SDMSOwnedObject)((Object)sDMSProxy);
            }
            if (this.owners.contains(sDMSOwnedObject.getOwnerId(systemEnvironment))) {
                return true;
            }
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException();
        }
        catch (SDMSException sDMSException) {
            // empty catch block
        }
        return false;
    }

    private void fillOwners(SystemEnvironment systemEnvironment) {
        if (this.owners == null) {
            this.owners = new HashSet();
            for (int i = 0; i < this.names.size(); ++i) {
                try {
                    Long l = ((SDMSGroup)SDMSGroupTable.idx_name.getUnique(systemEnvironment, this.names.get(i))).getId(systemEnvironment);
                    this.owners.add(l);
                    continue;
                }
                catch (SerializationException serializationException) {
                    throw new RuntimeException();
                }
                catch (SDMSException sDMSException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OwnerFilter)) {
            return false;
        }
        OwnerFilter ownerFilter = (OwnerFilter)object;
        if (this.owners == null) {
            this.fillOwners(this.env);
        }
        if (ownerFilter.owners == null) {
            ownerFilter.fillOwners(this.env);
        }
        if (this.owners.size() != ownerFilter.owners.size()) {
            return false;
        }
        Iterator iterator = this.owners.iterator();
        while (iterator.hasNext()) {
            if (ownerFilter.owners.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

