/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.parser.filter.Caster;
import de.independit.scheduler.server.parser.filter.Comparer;
import de.independit.scheduler.server.parser.filter.DoubleCaster;
import de.independit.scheduler.server.parser.filter.EQComparer;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.parser.filter.GEComparer;
import de.independit.scheduler.server.parser.filter.GTComparer;
import de.independit.scheduler.server.parser.filter.IntegerCaster;
import de.independit.scheduler.server.parser.filter.LEComparer;
import de.independit.scheduler.server.parser.filter.LTComparer;
import de.independit.scheduler.server.parser.filter.LikeComparer;
import de.independit.scheduler.server.parser.filter.NQComparer;
import de.independit.scheduler.server.parser.filter.NotLikeComparer;
import de.independit.scheduler.server.parser.filter.StringCaster;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventProxyGeneric;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.util.BoolExpr;
import java.util.HashMap;

public class ParameterFilter
extends Filter {
    final String name;
    final Comparable value;
    final String expression;
    final BoolExpr be;
    final String cmpop;
    Comparer c;
    Caster cst;
    static final Caster strCaster = new StringCaster();
    static final Caster intCaster = new IntegerCaster();
    static final Caster dblCaster = new DoubleCaster();

    public ParameterFilter(SystemEnvironment systemEnvironment, WithHash withHash) throws SDMSException {
        this.name = (String)withHash.get("NAME");
        Object object = withHash.get("VALUE");
        if (object instanceof WithItem) {
            object = ((WithItem)object).value;
            this.expression = object instanceof String ? (String)object : object.toString();
            this.value = null;
            this.be = new BoolExpr(this.expression);
            this.be.checkConditionSyntax(systemEnvironment);
        } else {
            this.value = (Comparable)object;
            this.expression = null;
            this.be = null;
        }
        this.cmpop = (String)withHash.get("CMPOP");
        this.cst = null;
        if (this.cmpop.equals("==")) {
            this.c = new EQComparer(systemEnvironment, this.value);
        } else if (this.cmpop.equals("!=")) {
            this.c = new NQComparer(systemEnvironment, this.value);
        } else if (this.cmpop.equals("<>")) {
            this.c = new NQComparer(systemEnvironment, this.value);
        } else if (this.cmpop.equals(">")) {
            this.c = new GTComparer(systemEnvironment, this.value);
        } else if (this.cmpop.equals(">=")) {
            this.c = new GEComparer(systemEnvironment, this.value);
        } else if (this.cmpop.equals("<")) {
            this.c = new LTComparer(systemEnvironment, this.value);
        } else if (this.cmpop.equals("<=")) {
            this.c = new LEComparer(systemEnvironment, this.value);
        } else if (this.cmpop.equals("=~")) {
            this.c = new LikeComparer(systemEnvironment, (Comparable)((Object)(this.value != null ? this.value.toString() : null)));
            this.cst = new StringCaster();
        } else if (this.cmpop.equals("LIKE")) {
            this.c = new LikeComparer(systemEnvironment, (Comparable)((Object)(this.value != null ? this.value.toString() : null)));
            this.cst = new StringCaster();
        } else if (this.cmpop.equals("!~")) {
            this.c = new NotLikeComparer(systemEnvironment, (Comparable)((Object)(this.value != null ? this.value.toString() : null)));
            this.cst = new StringCaster();
        } else if (this.cmpop.equals("NOTLIKE")) {
            this.c = new NotLikeComparer(systemEnvironment, (Comparable)((Object)(this.value != null ? this.value.toString() : null)));
            this.cst = new StringCaster();
        } else {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03511031050", "Unknown comparison operator: " + this.cmpop));
        }
        if (this.cst == null) {
            if (this.value instanceof String) {
                this.cst = strCaster;
            }
            if (this.value instanceof Integer) {
                this.cst = intCaster;
            }
            if (this.value instanceof Double) {
                this.cst = dblCaster;
            }
        }
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        ParameterFilterCache parameterFilterCache;
        String string = null;
        Long l = sDMSProxy.getId(systemEnvironment);
        if (systemEnvironment.tx.txData.containsKey("PARAMETERFILTER_CACHE")) {
            parameterFilterCache = (ParameterFilterCache)systemEnvironment.tx.txData.get("PARAMETERFILTER_CACHE");
            if (!parameterFilterCache.id.equals(l)) {
                parameterFilterCache.id = l;
                parameterFilterCache.parameters.clear();
            } else {
                string = (String)parameterFilterCache.parameters.get(this.name);
            }
        } else {
            parameterFilterCache = new ParameterFilterCache();
            parameterFilterCache.id = l;
            systemEnvironment.tx.txData.put("PARAMETERFILTER_CACHE", parameterFilterCache);
        }
        try {
            Object object;
            if (string == null) {
                if (sDMSProxy instanceof SDMSSubmittedEntity) {
                    object = (SDMSSubmittedEntity)sDMSProxy;
                    try {
                        string = ((SDMSSubmittedEntity)object).getVariableValue(systemEnvironment, this.name, true, "DEFAULT", this.be != null, true);
                    }
                    catch (NotFoundException notFoundException) {
                        string = null;
                    }
                } else if (sDMSProxy instanceof SDMSSchedulingEntity) {
                    object = (SDMSSchedulingEntity)sDMSProxy;
                    try {
                        string = ((SDMSSchedulingEntity)object).getVariableValue(systemEnvironment, this.name, true);
                    }
                    catch (NotFoundException notFoundException) {
                        string = null;
                    }
                } else if (sDMSProxy instanceof SDMSCalendar) {
                    try {
                        object = SDMSScheduledEventTable.getObject(systemEnvironment, ((SDMSCalendar)sDMSProxy).getScevId(systemEnvironment));
                        SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, ((SDMSScheduledEventProxyGeneric)object).getEvtId(systemEnvironment));
                        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSEvent.getSeId(systemEnvironment));
                        string = sDMSSchedulingEntity.getVariableValue(systemEnvironment, this.name, true);
                    }
                    catch (NotFoundException notFoundException) {
                        string = null;
                    }
                } else if (sDMSProxy instanceof SDMSScheduledEvent) {
                    try {
                        object = SDMSEventTable.getObject(systemEnvironment, ((SDMSScheduledEvent)sDMSProxy).getEvtId(systemEnvironment));
                        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSEventProxyGeneric)object).getSeId(systemEnvironment));
                        string = sDMSSchedulingEntity.getVariableValue(systemEnvironment, this.name, true);
                    }
                    catch (NotFoundException notFoundException) {
                        string = null;
                    }
                }
                if (string != null) {
                    parameterFilterCache.parameters.put(this.name, string);
                }
            }
            if (string != null) {
                if (this.be != null) {
                    if (!(sDMSProxy instanceof SDMSSubmittedEntity)) {
                        return false;
                    }
                    object = this.be.evalExpression(systemEnvironment, null, (SDMSSubmittedEntity)sDMSProxy, (SDMSSubmittedEntity)sDMSProxy, null, null, null);
                    if (object instanceof String) {
                        this.cst = strCaster;
                        this.c.setValue((Comparable)((Object)((String)object)));
                    } else if (object instanceof Long) {
                        this.cst = intCaster;
                        this.c.setValue((Long)object);
                    } else if (object instanceof Double) {
                        this.cst = dblCaster;
                        this.c.setValue((Double)object);
                    }
                }
                return this.c.cmp(this.cst.cast(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ParameterFilter)) {
            return false;
        }
        ParameterFilter parameterFilter = (ParameterFilter)object;
        if (!this.name.equals(parameterFilter.name)) {
            return false;
        }
        if (this.value == null && parameterFilter.value != null) {
            return false;
        }
        if (this.value != null && parameterFilter.value == null) {
            return false;
        }
        if (this.value != null && this.value.compareTo(parameterFilter.value) != 0) {
            return false;
        }
        if (this.expression != null && this.expression.compareTo(parameterFilter.expression) != 0) {
            return false;
        }
        return this.cmpop.equals(parameterFilter.cmpop);
    }

    class ParameterFilterCache {
        protected Long id = null;
        protected HashMap parameters = new HashMap();

        ParameterFilterCache() {
        }
    }
}

