/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfileProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.util.Iterator;
import java.util.Vector;

public class SDMSExitStateProfile
extends SDMSExitStateProfileProxyGeneric {
    public static final String __version = "@(#) $Id: SDMSExitStateProfile.java,v 2.7.2.2 2013/03/19 17:16:51 ronald Exp $";

    protected SDMSExitStateProfile(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public void validateMappingProfile(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSExitStateMappingTable.idx_esmpId.getVector(systemEnvironment, l);
        Vector vector2 = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l2);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Long l3 = ((SDMSExitStateMapping)iterator.next()).getEsdId(systemEnvironment);
            boolean bl = false;
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                Long l4 = ((SDMSExitState)iterator2.next()).getEsdId(systemEnvironment);
                if (!l3.equals(l4)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02111081735", "Exit State Mapping not compatible with Exit State Profile"));
        }
    }

    public void checkProfile(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Long l2 = this.getDefaultEsmpId(systemEnvironment);
        if (l2 != null) {
            this.validateMappingProfile(systemEnvironment, l2);
        }
        Vector vector = SDMSSchedulingEntityTable.idx_espId.getVector(systemEnvironment, l);
        for (SDMSSchedulingEntity sDMSSchedulingEntity : vector) {
            Long l3;
            Long l4 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
            if (l4 != null) {
                try {
                    this.validateMappingProfile(systemEnvironment, l4);
                }
                catch (CommonErrorException commonErrorException) {
                    SDMSExitStateMappingProfile sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l4);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112191851", "Exit State Mapping $1 of Job $2 not copatible with Profile", sDMSExitStateMappingProfile.getName(systemEnvironment), sDMSSchedulingEntity.getName(systemEnvironment)));
                }
            }
            if ((l3 = sDMSSchedulingEntity.getTimeoutStateId(systemEnvironment)) != null && !SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, new SDMSKey(l, l3))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03311051011", "Timeout state $1 of $2 not defined within profile", SDMSExitStateDefinitionTable.getObject(systemEnvironment, l3).getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment)));
            }
            this.checkChildTranslations(systemEnvironment, l, sDMSSchedulingEntity);
            this.checkParentTranslations(systemEnvironment, l, sDMSSchedulingEntity);
            this.checkDependencies(systemEnvironment, l, sDMSSchedulingEntity);
        }
        this.setIsValid(systemEnvironment, Boolean.TRUE);
    }

    private void checkChildTranslations(SystemEnvironment systemEnvironment, Long l, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector vector = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy : vector) {
            SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeChildId(systemEnvironment));
            Long l2 = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
            SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile = l2 == null ? null : SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l2);
            Long l3 = sDMSSchedulingEntity2.getEspId(systemEnvironment);
            if (sDMSExitStateTranslationProfile == null) continue;
            Vector vector2 = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l3);
            for (SDMSExitState sDMSExitState : vector2) {
                Object object;
                Long l4;
                Long l5 = l4 = sDMSExitState.getEsdId(systemEnvironment);
                if (sDMSExitStateTranslationProfile != null && (l5 = sDMSExitStateTranslationProfile.translate(systemEnvironment, l4, false)) == null) continue;
                SDMSKey sDMSKey = new SDMSKey(l, l5);
                if (!SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, sDMSKey)) {
                    object = new Object[]{SDMSExitStateDefinitionTable.getObject(systemEnvironment, l4).getName(systemEnvironment), sDMSSchedulingEntity2.pathString(systemEnvironment), SDMSExitStateDefinitionTable.getObject(systemEnvironment, l5).getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment), sDMSExitStateTranslationProfile == null ? "NONE" : sDMSExitStateTranslationProfile.getName(systemEnvironment)};
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112172235", "Profile doesn't contain state $3 of $4 translated from child state $1 of $2, Translation = [$5]", (Object[])object));
                }
                object = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, sDMSKey);
                if (!((SDMSExitStateProxyGeneric)object).getIsFinal(systemEnvironment).equals(Boolean.FALSE) || !sDMSExitState.getIsFinal(systemEnvironment).equals(Boolean.TRUE)) continue;
                Object[] objectArray = new Object[]{SDMSExitStateDefinitionTable.getObject(systemEnvironment, l4).getName(systemEnvironment), sDMSSchedulingEntity2.pathString(systemEnvironment), SDMSExitStateDefinitionTable.getObject(systemEnvironment, l5).getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment), sDMSExitStateTranslationProfile == null ? "NONE" : sDMSExitStateTranslationProfile.getName(systemEnvironment)};
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205061627", "Invalid trasnlation from final child state $1 of $2 to non final state $3 of $4, Translation = [$5]", objectArray));
            }
        }
    }

    private void checkParentTranslations(SystemEnvironment systemEnvironment, Long l, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l);
        Vector vector2 = SDMSSchedulingHierarchyTable.idx_seChildId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy : vector2) {
            SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeParentId(systemEnvironment));
            Long l2 = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
            if (l2 == null) continue;
            SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l2);
            Long l3 = sDMSSchedulingEntity2.getEspId(systemEnvironment);
            if (l3.equals(l)) continue;
            for (SDMSExitState sDMSExitState : vector) {
                SDMSProxy sDMSProxy;
                Long l4;
                Long l5 = l4 = sDMSExitState.getEsdId(systemEnvironment);
                l5 = sDMSExitStateTranslationProfile.translate(systemEnvironment, l4, false);
                if (l5 == null) continue;
                SDMSKey sDMSKey = new SDMSKey(l3, l5);
                if (!SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, sDMSKey)) {
                    sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeChildId(systemEnvironment));
                    Object[] objectArray = new Object[]{SDMSExitStateDefinitionTable.getObject(systemEnvironment, l4).getName(systemEnvironment), ((SDMSSchedulingEntity)sDMSProxy).pathString(systemEnvironment), sDMSSchedulingEntity2.pathString(systemEnvironment), sDMSExitStateTranslationProfile.getName(systemEnvironment)};
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201292033", "Profile contains state $1 not translating from $2 to $3 Translation $4", objectArray));
                }
                sDMSProxy = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, sDMSKey);
                if (!((SDMSExitStateProxyGeneric)sDMSProxy).getIsFinal(systemEnvironment).equals(Boolean.FALSE) || !sDMSExitState.getIsFinal(systemEnvironment).equals(Boolean.TRUE)) continue;
                Object[] objectArray = new Object[]{SDMSExitStateDefinitionTable.getObject(systemEnvironment, l4).getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment), SDMSExitStateDefinitionTable.getObject(systemEnvironment, l5).getName(systemEnvironment), sDMSSchedulingEntity2.pathString(systemEnvironment), sDMSExitStateTranslationProfile == null ? "NONE" : sDMSExitStateTranslationProfile.getName(systemEnvironment)};
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205061726", "Invalid translation from final child state $1 of $2 to non final state $3 of $4, Translation = [$5]", objectArray));
            }
        }
    }

    private void checkDependencies(SystemEnvironment systemEnvironment, Long l, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l);
        Vector vector2 = SDMSDependencyDefinitionTable.idx_seRequiredId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        for (SDMSDependencyDefinition sDMSDependencyDefinition : vector2) {
            Vector vector3 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, sDMSDependencyDefinition.getId(systemEnvironment));
            block1: for (SDMSDependencyState sDMSDependencyState : vector3) {
                SDMSProxy sDMSProxy2;
                Long l2 = sDMSDependencyState.getEsdId(systemEnvironment);
                for (SDMSProxy sDMSProxy2 : vector) {
                    if (!l2.equals(((SDMSExitStateProxyGeneric)sDMSProxy2).getEsdId(systemEnvironment)) || !((SDMSExitStateProxyGeneric)sDMSProxy2).getIsFinal(systemEnvironment).booleanValue()) continue;
                    continue block1;
                }
                sDMSProxy2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeDependentId(systemEnvironment));
                SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2);
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112201408", "Job $1 depends on Exit State $2 of Job $3, not longer a final exit state", ((SDMSSchedulingEntity)sDMSProxy2).pathString(systemEnvironment), sDMSExitStateDefinition.getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment)));
            }
        }
    }

    public boolean isPendingState(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        if (l == null) {
            return false;
        }
        Long l3 = this.getId(systemEnvironment);
        SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l3, l), l2);
        return sDMSExitState.getIsFinal(systemEnvironment) == false && sDMSExitState.getIsRestartable(systemEnvironment) == false;
    }

    public Long getBrokenState(SystemEnvironment systemEnvironment) throws SDMSException {
        if (systemEnvironment.tx.mode == 2) {
            return this.getBrokenState(systemEnvironment, Long.MAX_VALUE);
        }
        return this.getBrokenState(systemEnvironment, systemEnvironment.tx.versionId);
    }

    public Long getBrokenState(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, (Object)this.getId(systemEnvironment), l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSExitState sDMSExitState = (SDMSExitState)vector.get(i);
            if (!sDMSExitState.getIsBroken(systemEnvironment).booleanValue()) continue;
            return sDMSExitState.getEsdId(systemEnvironment);
        }
        return null;
    }

    public Long getUnreachableState(SystemEnvironment systemEnvironment) throws SDMSException {
        if (systemEnvironment.tx.mode == 2) {
            return this.getUnreachableState(systemEnvironment, Long.MAX_VALUE);
        }
        return this.getUnreachableState(systemEnvironment, systemEnvironment.tx.versionId);
    }

    public Long getUnreachableState(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, (Object)this.getId(systemEnvironment), l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSExitState sDMSExitState = (SDMSExitState)vector.get(i);
            if (!sDMSExitState.getIsUnreachable(systemEnvironment).booleanValue()) continue;
            return sDMSExitState.getEsdId(systemEnvironment);
        }
        return null;
    }

    public Integer getUnreachableStatePreference(SystemEnvironment systemEnvironment) throws SDMSException {
        if (systemEnvironment.tx.mode == 2) {
            return this.getUnreachableStatePreference(systemEnvironment, Long.MAX_VALUE);
        }
        return this.getUnreachableStatePreference(systemEnvironment, systemEnvironment.tx.versionId);
    }

    public Integer getUnreachableStatePreference(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, (Object)this.getId(systemEnvironment), l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSExitState sDMSExitState = (SDMSExitState)vector.get(i);
            if (!sDMSExitState.getIsUnreachable(systemEnvironment).booleanValue()) continue;
            return sDMSExitState.getPreference(systemEnvironment);
        }
        return null;
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getName(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "exit state profile " + this.getURLName(systemEnvironment);
    }
}

