/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSExtents;
import de.independit.scheduler.server.repository.SDMSExtentsGeneric;
import de.independit.scheduler.server.repository.SDMSExtentsTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSExtentsTableGeneric
extends SDMSTable {
    public static final String tableName = "EXTENTS";
    public static SDMSExtentsTable table = null;
    public static final String[] columnNames = new String[]{"ID", "O_ID", "SME_ID", "SEQUENCE", "EXTENT", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_oId;
    public static SDMSIndex idx_smeId;

    public SDMSExtentsTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Extents"));
        }
        table = (SDMSExtentsTable)this;
        table = (SDMSExtentsTable)this;
        this.isVersioned = false;
        idx_oId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "oId");
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
    }

    public SDMSExtents create(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, String string) throws SDMSException {
        SDMSExtents sDMSExtents;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Extents"));
        }
        this.validate(systemEnvironment, l, l2, n, string, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSExtentsGeneric sDMSExtentsGeneric = new SDMSExtentsGeneric(systemEnvironment, l, l2, n, string, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSExtentsGeneric.versions, true);
            table.put(systemEnvironment, sDMSExtentsGeneric.id, sDMSExtentsGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSExtents = (SDMSExtents)sDMSExtentsGeneric.toProxy(systemEnvironment);
            sDMSExtents.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSExtents sDMSExtents2 = (SDMSExtents)sDMSExtentsGeneric.toProxy(systemEnvironment);
            sDMSExtents2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSExtents)) {
            throw new AccessViolationException(sDMSExtents.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSExtents;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSExtents sDMSExtents) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, String string, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Integer n;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = resultSet.getLong(1);
            l8 = resultSet.getLong(2);
            l7 = resultSet.getLong(3);
            n = resultSet.getInt(4);
            string = resultSet.getString(5);
            l6 = resultSet.getLong(6);
            l5 = resultSet.getLong(7);
            l4 = resultSet.getLong(8);
            l3 = resultSet.getLong(9);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Extents: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSExtentsGeneric(l9, l8, l7, n, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "O_ID" + string2 + ", " + string + "SME_ID" + string2 + ", " + string + "SEQUENCE" + string2 + ", " + string + "EXTENT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + ",        SME2LOAD  WHERE " + string + this.tableName() + string2 + ".SME_ID = SME2LOAD.ID");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_oId.check(((SDMSExtentsGeneric)sDMSObject).oId, sDMSObject);
        string = string + "idx_oId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_smeId.check(((SDMSExtentsGeneric)sDMSObject).smeId, sDMSObject);
        string = string + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_oId.put(systemEnvironment, ((SDMSExtentsGeneric)sDMSObject).oId, sDMSObject, (1L & l) != 0L);
        idx_smeId.put(systemEnvironment, ((SDMSExtentsGeneric)sDMSObject).smeId, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_oId.remove(systemEnvironment, ((SDMSExtentsGeneric)sDMSObject).oId, sDMSObject);
        idx_smeId.remove(systemEnvironment, ((SDMSExtentsGeneric)sDMSObject).smeId, sDMSObject);
    }

    public static SDMSExtents getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExtents)table.get(systemEnvironment, l);
    }

    public static SDMSExtents getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExtents)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSExtents getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSExtents)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

