/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.Vector;

public class SDMSIntervalHierarchyProxyGeneric
extends SDMSProxy {
    public static final long privilegeMask = 0x10000111L;
    private static SDMSTable[] masterTables = null;

    protected SDMSIntervalHierarchyProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSIntervalHierarchy getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSIntervalHierarchyTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSIntervalHierarchy(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSIntervalHierarchy)sDMSProxy;
    }

    public Long getChildId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalHierarchyGeneric)this.object).getChildId(systemEnvironment);
    }

    public void setChildId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setChildId(systemEnvironment, l);
    }

    @Override
    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalHierarchyGeneric)this.object).getParentId(systemEnvironment);
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setParentId(systemEnvironment, l);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalHierarchyGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalHierarchyGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalHierarchyGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSIntervalHierarchy setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSIntervalHierarchy)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSIntervalHierarchyGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSIntervalHierarchy setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSIntervalHierarchyGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSIntervalHierarchy)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(this.getId(systemEnvironment));
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x10000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l2 = 0L;
        l2 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "INTERVALL");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getParentId(systemEnvironment));
            long l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l2 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing IntervalHierarchy $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "INTERVALL");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getParentId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSIntervalHierarchyGeneric)this.object).print();
    }
}

