/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.NicedMastersFilter;
import de.independit.scheduler.server.repository.NpeComparator;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntry;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import de.independit.scheduler.server.repository.SDMSNiceProfileProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNiceProfileTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.util.SDMSFilter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class SDMSNiceProfile
extends SDMSNiceProfileProxyGeneric {
    protected SDMSNiceProfile(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public void setIsActive(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.setIsActive(systemEnvironment, bl, null);
    }

    public void setIsActive(SystemEnvironment systemEnvironment, Boolean bl, Long l) throws SDMSException {
        boolean bl2;
        boolean bl3 = this.getIsActive(systemEnvironment);
        if (bl3 == (bl2 = bl.booleanValue())) {
            return;
        }
        super.setIsActive(systemEnvironment, bl);
        if (bl2) {
            if (l == null) {
                Date date = new Date();
                l = date.getTime();
            }
            this.setActiveTs(systemEnvironment, l);
            this.activate(systemEnvironment, l);
        } else {
            this.deactivate(systemEnvironment);
            this.setActiveTs(systemEnvironment, null);
        }
    }

    Vector getSortedEntries(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSNiceProfileEntryTable.idx_npId.getVector(systemEnvironment, this.getId(systemEnvironment));
        NpeComparator npeComparator = new NpeComparator(systemEnvironment);
        Collections.sort(vector, npeComparator);
        return vector;
    }

    private SDMSNiceProfileEntry matchId(SystemEnvironment systemEnvironment, Vector vector, Long l) throws SDMSException {
        for (SDMSNiceProfileEntry sDMSNiceProfileEntry : vector) {
            if (!sDMSNiceProfileEntry.getIsActive(systemEnvironment).booleanValue() || !l.equals(sDMSNiceProfileEntry.getFolderId(systemEnvironment))) continue;
            return sDMSNiceProfileEntry;
        }
        return null;
    }

    public SDMSNiceProfileEntry match(SystemEnvironment systemEnvironment, Vector vector, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSNiceProfileEntry sDMSNiceProfileEntry = null;
        Long l = sDMSSubmittedEntity.getSeId(systemEnvironment);
        sDMSNiceProfileEntry = this.matchId(systemEnvironment, vector, l);
        if (sDMSNiceProfileEntry == null) {
            long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l, l2);
            Long l3 = sDMSSchedulingEntity.getFolderId(systemEnvironment);
            while (l3 != null && (sDMSNiceProfileEntry = this.matchId(systemEnvironment, vector, l3)) == null) {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l3, l2);
                l3 = sDMSFolder.getParentId(systemEnvironment);
            }
        }
        return sDMSNiceProfileEntry;
    }

    private Vector getMasters(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        final long l2 = l;
        Vector vector = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, null, new SDMSFilter(){

            @Override
            public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                SDMSNiceProfileEntry sDMSNiceProfileEntry;
                SDMSNiceProfile sDMSNiceProfile;
                int n = ((SDMSSubmittedEntity)sDMSProxy).getState(systemEnvironment);
                if (n == 12 || n == 10 || ((SDMSSubmittedEntity)sDMSProxy).getIsCancelled(systemEnvironment).booleanValue()) {
                    return false;
                }
                Long l = ((SDMSSubmittedEntity)sDMSProxy).getNpeId(systemEnvironment);
                return l == null || (sDMSNiceProfile = SDMSNiceProfileTable.getObject(systemEnvironment, (sDMSNiceProfileEntry = SDMSNiceProfileEntryTable.getObject(systemEnvironment, l)).getNpId(systemEnvironment))).getActiveTs(systemEnvironment) <= l2;
            }
        });
        return vector;
    }

    private void activate(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        String string = "Renice caused by activation of Nice Profile " + this.getName(systemEnvironment);
        Vector vector = this.getSortedEntries(systemEnvironment);
        Vector vector2 = this.getMasters(systemEnvironment, l);
        for (SDMSSubmittedEntity sDMSSubmittedEntity : vector2) {
            int n;
            SDMSNiceProfileEntry sDMSNiceProfileEntry = this.match(systemEnvironment, vector, sDMSSubmittedEntity);
            if (sDMSNiceProfileEntry == null) continue;
            int n2 = n = sDMSSubmittedEntity.getNpNice(systemEnvironment).intValue();
            Long l2 = sDMSSubmittedEntity.getNpeId(systemEnvironment);
            if (l2 != null) {
                n -= SDMSNiceProfileEntryTable.getObject(systemEnvironment, l2).getRenice(systemEnvironment).intValue();
            }
            if ((n += sDMSNiceProfileEntry.getRenice(systemEnvironment).intValue()) != n2) {
                sDMSSubmittedEntity.renice(systemEnvironment, null, n, string);
            }
            sDMSSubmittedEntity.setNpeId(systemEnvironment, sDMSNiceProfileEntry.getId(systemEnvironment));
            int n3 = sDMSNiceProfileEntry.getIsSuspended(systemEnvironment);
            int n4 = sDMSSubmittedEntity.getIsSuspended(systemEnvironment);
            Long l3 = sDMSSubmittedEntity.getOpSusresTs(systemEnvironment);
            long l4 = 0L;
            if (l3 != null) {
                l4 = l3;
            }
            Date date = new Date();
            Long l5 = date.getTime();
            if (n3 == 0) {
                if (n4 == 0 || l4 < 0L) continue;
                SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l5, SDMSConstants.AT_RESUME, SDMSConstants.AT_JOB, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, "Resume caused by activation of Nice Profile " + this.getName(systemEnvironment));
                sDMSSubmittedEntity.resume(systemEnvironment, true, false);
                continue;
            }
            if (n4 == n3) continue;
            boolean bl = false;
            String string2 = "";
            if (n3 == 2) {
                bl = true;
                string2 = "Admin ";
            }
            SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l5, SDMSConstants.AT_SUSPEND, SDMSConstants.AT_JOB, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, string2 + "Suspend caused by activation of Nice Profile " + this.getName(systemEnvironment));
            sDMSSubmittedEntity.suspend(systemEnvironment, false, bl, false);
        }
    }

    private Vector getNicedMasters(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        NicedMastersFilter nicedMastersFilter = new NicedMastersFilter(systemEnvironment, vector);
        Vector vector2 = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, null, nicedMastersFilter);
        return vector2;
    }

    public static Vector getActiveNiceProfiles(SystemEnvironment systemEnvironment) throws SDMSException {
        Iterator iterator = SDMSNiceProfileTable.table.iterator(systemEnvironment, new SDMSFilter(){

            @Override
            public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                return ((SDMSNiceProfile)sDMSProxy).getIsActive(systemEnvironment) != false;
            }
        }, false);
        Vector<SDMSNiceProfile> vector = new Vector<SDMSNiceProfile>();
        while (iterator.hasNext()) {
            SDMSNiceProfile sDMSNiceProfile;
            long l;
            int n;
            SDMSNiceProfile sDMSNiceProfile2 = (SDMSNiceProfile)iterator.next();
            long l2 = sDMSNiceProfile2.getActiveTs(systemEnvironment);
            for (n = 0; n < vector.size() && (l = (sDMSNiceProfile = (SDMSNiceProfile)vector.elementAt(n)).getActiveTs(systemEnvironment).longValue()) >= l2; ++n) {
            }
            vector.insertElementAt(sDMSNiceProfile2, n);
        }
        return vector;
    }

    private Vector getPreviousActiveNiceProfiles(SystemEnvironment systemEnvironment) throws SDMSException {
        final long l = this.getActiveTs(systemEnvironment);
        Iterator iterator = SDMSNiceProfileTable.table.iterator(systemEnvironment, new SDMSFilter(){

            @Override
            public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                if (!((SDMSNiceProfile)sDMSProxy).getIsActive(systemEnvironment).booleanValue()) {
                    return false;
                }
                long l2 = ((SDMSNiceProfile)sDMSProxy).getActiveTs(systemEnvironment);
                return l2 < l;
            }
        }, false);
        Vector<SDMSNiceProfile> vector = new Vector<SDMSNiceProfile>();
        while (iterator.hasNext()) {
            SDMSNiceProfile sDMSNiceProfile;
            long l2;
            int n;
            SDMSNiceProfile sDMSNiceProfile2 = (SDMSNiceProfile)iterator.next();
            long l3 = sDMSNiceProfile2.getActiveTs(systemEnvironment);
            for (n = 0; n < vector.size() && (l2 = (sDMSNiceProfile = (SDMSNiceProfile)vector.elementAt(n)).getActiveTs(systemEnvironment).longValue()) >= l3; ++n) {
            }
            vector.insertElementAt(sDMSNiceProfile2, n);
        }
        return vector;
    }

    private void deactivate(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "Renice caused by deactivation of Nice Profile " + this.getName(systemEnvironment);
        Vector vector = this.getSortedEntries(systemEnvironment);
        Vector vector2 = this.getNicedMasters(systemEnvironment, vector);
        Vector vector3 = this.getPreviousActiveNiceProfiles(systemEnvironment);
        HashMap<Long, Vector> hashMap = new HashMap<Long, Vector>();
        for (SDMSSubmittedEntity sDMSSubmittedEntity : vector2) {
            int n;
            SDMSNiceProfileEntry sDMSNiceProfileEntry = SDMSNiceProfileEntryTable.getObject(systemEnvironment, sDMSSubmittedEntity.getNpeId(systemEnvironment));
            SDMSNiceProfileEntryProxyGeneric sDMSNiceProfileEntryProxyGeneric = null;
            for (SDMSNiceProfile sDMSNiceProfile : vector3) {
                Long l = sDMSNiceProfile.getId(systemEnvironment);
                Vector vector4 = null;
                if (hashMap.containsKey(l)) {
                    vector4 = (Vector)hashMap.get(l);
                } else {
                    vector4 = sDMSNiceProfile.getSortedEntries(systemEnvironment);
                    hashMap.put(l, vector4);
                }
                if ((sDMSNiceProfileEntryProxyGeneric = this.match(systemEnvironment, vector4, sDMSSubmittedEntity)) == null) continue;
                break;
            }
            int n2 = n = sDMSSubmittedEntity.getNpNice(systemEnvironment).intValue();
            n -= sDMSNiceProfileEntry.getRenice(systemEnvironment).intValue();
            int n3 = 0;
            long l = 0L;
            if (sDMSNiceProfileEntryProxyGeneric != null) {
                n += sDMSNiceProfileEntryProxyGeneric.getRenice(systemEnvironment).intValue();
                sDMSSubmittedEntity.setNpeId(systemEnvironment, sDMSNiceProfileEntryProxyGeneric.getId(systemEnvironment));
                n3 = sDMSNiceProfileEntryProxyGeneric.getIsSuspended(systemEnvironment);
                SDMSNiceProfile sDMSNiceProfile = SDMSNiceProfileTable.getObject(systemEnvironment, sDMSNiceProfileEntryProxyGeneric.getNpId(systemEnvironment));
                l = sDMSNiceProfile.getActiveTs(systemEnvironment);
            } else {
                sDMSSubmittedEntity.setNpeId(systemEnvironment, null);
            }
            if (n != n2) {
                sDMSSubmittedEntity.renice(systemEnvironment, null, n, string);
            }
            int n4 = sDMSSubmittedEntity.getIsSuspended(systemEnvironment);
            Long l2 = sDMSSubmittedEntity.getOpSusresTs(systemEnvironment);
            long l3 = 0L;
            if (l2 != null) {
                l3 = l2;
            }
            Date date = new Date();
            Long l4 = date.getTime();
            if (l3 > l) {
                n3 = 0;
            }
            if (n3 == 0) {
                if (n4 == 0 || l3 < 0L) continue;
                SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l4, SDMSConstants.AT_RESUME, SDMSConstants.AT_JOB, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, "Resume caused by deactivation of Nice Profile " + this.getName(systemEnvironment));
                sDMSSubmittedEntity.resume(systemEnvironment, true, false);
                continue;
            }
            if (n4 == n3 || l3 >= l) continue;
            boolean bl = false;
            String string2 = "";
            if (n3 == 2) {
                bl = true;
                string2 = "Admin ";
            }
            SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l4, SDMSConstants.AT_SUSPEND, SDMSConstants.AT_JOB, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, string2 + "Suspend caused by deactivation of Nice Profile " + this.getName(systemEnvironment));
            sDMSSubmittedEntity.suspend(systemEnvironment, false, bl, false);
        }
    }
}

