/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSNiceProfileGeneric;
import de.independit.scheduler.server.repository.SDMSNiceProfileTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSNiceProfileTableGeneric
extends SDMSTable {
    public static final String tableName = "NICE_PROFILE";
    public static SDMSNiceProfileTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "IS_ACTIVE", "ACTIVE_TS", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;

    public SDMSNiceProfileTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "NiceProfile"));
        }
        table = (SDMSNiceProfileTable)this;
        table = (SDMSNiceProfileTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
    }

    public SDMSNiceProfile create(SystemEnvironment systemEnvironment, String string, Boolean bl, Long l) throws SDMSException {
        SDMSNiceProfile sDMSNiceProfile;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "NiceProfile"));
        }
        this.validate(systemEnvironment, string, bl, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSNiceProfileGeneric sDMSNiceProfileGeneric = new SDMSNiceProfileGeneric(systemEnvironment, string, bl, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSNiceProfileGeneric.versions, true);
            table.put(systemEnvironment, sDMSNiceProfileGeneric.id, sDMSNiceProfileGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSNiceProfile = (SDMSNiceProfile)sDMSNiceProfileGeneric.toProxy(systemEnvironment);
            sDMSNiceProfile.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSNiceProfile sDMSNiceProfile2 = (SDMSNiceProfile)sDMSNiceProfileGeneric.toProxy(systemEnvironment);
            sDMSNiceProfile2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSNiceProfile)) {
            throw new AccessViolationException(sDMSNiceProfile.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSNiceProfile;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSNiceProfile sDMSNiceProfile) throws SDMSException {
        return sDMSNiceProfile.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Boolean bl, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Boolean bl;
        String string;
        Long l8;
        try {
            l8 = resultSet.getLong(1);
            string = resultSet.getString(2);
            bl = resultSet.getInt(3) != 0;
            l7 = resultSet.getLong(4);
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = resultSet.getLong(5);
            l5 = resultSet.getLong(6);
            l4 = resultSet.getLong(7);
            l3 = resultSet.getLong(8);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "NiceProfile: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSNiceProfileGeneric(l8, string, bl, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "IS_ACTIVE" + string2 + ", " + string + "ACTIVE_TS" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSNiceProfileGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSNiceProfileGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSNiceProfileGeneric)sDMSObject).name, sDMSObject);
    }

    public static SDMSNiceProfile getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSNiceProfile)table.get(systemEnvironment, l);
    }

    public static SDMSNiceProfile getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSNiceProfile)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSNiceProfile getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSNiceProfile)table.get(systemEnvironment, l, l2);
    }

    public static SDMSNiceProfile idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSNiceProfile)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSNiceProfile idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSNiceProfile)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSNiceProfile idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSNiceProfile)idx_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

