/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentGeneric;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSObjectCommentProxyGeneric
extends SDMSProxy {
    public static final int SYSTEM = 0;
    public static final int SELECT = 99;
    public static final int DISTRIBUTION = 25;
    public static final int ENVIRONMENT = 1;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int FOLDER = 6;
    public static final int FOOTPRINT = 7;
    public static final int USER = 8;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int NICE_PROFILE = 31;
    public static final int PARAMETER = 23;
    public static final int POOL = 24;
    public static final int RESOURCE = 11;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int SCOPE = 15;
    public static final int TRIGGER = 16;
    public static final int JOB = 17;
    public static final int EVENT = 18;
    public static final int INTERVAL = 19;
    public static final int SCHEDULE = 20;
    public static final int GROUP = 21;
    public static final int SCHEDULED_EVENT = 22;
    public static final int COMMENT = 26;
    public static final int GRANT = 27;
    public static final int RESOURCE_TEMPLATE = 28;
    public static final int WATCH_TYPE = 29;
    public static final int OBJECT_MONITOR = 30;
    public static final int TEXT = 0;
    public static final int URL = 1;
    public static final long privilegeMask = 0x10000111L;
    public static final int tag_size = 64;
    public static final int description_size = 1900;
    private static SDMSTable[] masterTables = null;

    protected SDMSObjectCommentProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSObjectComment getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSObjectCommentTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSObjectComment(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSObjectComment)sDMSProxy;
    }

    public Long getObjectId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getObjectId(systemEnvironment);
    }

    public void setObjectId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setObjectId(systemEnvironment, l);
    }

    public Integer getObjectType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getObjectType(systemEnvironment);
    }

    public String getObjectTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getObjectTypeAsString(systemEnvironment);
    }

    public void setObjectType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setObjectType(systemEnvironment, n);
    }

    public Integer getInfoType(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getInfoType(systemEnvironment);
    }

    public String getInfoTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getInfoTypeAsString(systemEnvironment);
    }

    public void setInfoType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setInfoType(systemEnvironment, n);
    }

    public Integer getSequenceNumber(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getSequenceNumber(systemEnvironment);
    }

    public void setSequenceNumber(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setSequenceNumber(systemEnvironment, n);
    }

    public String getTag(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getTag(systemEnvironment);
    }

    public void setTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setTag(systemEnvironment, string);
    }

    public static int getTagMaxLength() {
        return 64;
    }

    public String getDescription(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getDescription(systemEnvironment);
    }

    public void setDescription(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setDescription(systemEnvironment, string);
    }

    public static int getDescriptionMaxLength() {
        return 1900;
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSObjectComment setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSObjectComment)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSObjectCommentGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSObjectComment setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSObjectCommentGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSObjectComment)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add(this.getObjectId(systemEnvironment));
        sDMSKey.add(this.getSequenceNumber(systemEnvironment));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l, long l2) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null, l2) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x10000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2;
        SDMSProxy sDMSProxy;
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l3 = 0L;
        l3 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_ENVIRONMENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_MAPPING_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_TRANS_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOLDER");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOOTPRINT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "GROUPS");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "INTERVALL");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NICE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "OBJECT_MONITOR");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "PARAMETER_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL_DISTRIBUTION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_MAP_PROF");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_TEMPLATE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULED_EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCOPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "TRIGGER_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "USERS");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "WATCH_TYPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            l2 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l2 & 0x100L) == 256L) {
                l2 |= 0x10000011L;
            }
            l3 &= l2;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l3;
    }

    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, null, l));
    }

    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x10000111L, false, vector, l));
    }

    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        long l3;
        SDMSProxy sDMSProxy;
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l4 = 0L;
        l4 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_ENVIRONMENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_MAPPING_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_TRANS_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOLDER");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOOTPRINT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "GROUPS");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "INTERVALL");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NICE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "OBJECT_MONITOR");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "PARAMETER_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL_DISTRIBUTION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_MAP_PROF");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_TEMPLATE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULED_EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCOPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "TRIGGER_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "USERS");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "WATCH_TYPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment), l2);
            l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l4 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l4;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing ObjectComment $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_ENVIRONMENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_MAPPING_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "EXIT_STATE_TRANS_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOLDER");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "FOOTPRINT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "GROUPS");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "INTERVALL");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SUBMITTED_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NICE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "OBJECT_MONITOR");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "PARAMETER_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL_DISTRIBUTION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_MAP_PROF");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_STATE_PROFILE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESOURCE_TEMPLATE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULED_EVENT");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCOPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "TRIGGER_DEFINITION");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "USERS");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "WATCH_TYPE");
        try {
            sDMSProxy = sDMSTable.get(systemEnvironment, this.getObjectId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSObjectCommentGeneric)this.object).print();
    }
}

