/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSVersionedExtents;
import de.independit.scheduler.server.repository.SDMSVersionedExtentsProxyGeneric;
import de.independit.scheduler.server.repository.SDMSVersionedExtentsTable;
import java.util.HashSet;
import java.util.Vector;

public class SDMSParameterDefinition
extends SDMSParameterDefinitionProxyGeneric {
    public static final String __version = "SDMSParameterDefinition $Revision: 2.2.6.1 $ / @(#) $Id: SDMSParameterDefinition.java,v 2.2.6.1 2013/03/14 10:25:21 ronald Exp $";

    protected SDMSParameterDefinition(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    private void deleteExtents(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSVersionedExtentsTable.idx_oId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSVersionedExtents sDMSVersionedExtents = (SDMSVersionedExtents)vector.get(i);
            sDMSVersionedExtents.delete(systemEnvironment);
        }
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(this.getSeId(systemEnvironment));
        this.delete(systemEnvironment, hashSet, false);
    }

    public void delete(SystemEnvironment systemEnvironment, HashSet<Long> hashSet, boolean bl) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSParameterDefinitionTable.idx_linkPdId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(i);
            if (hashSet.contains(sDMSParameterDefinition.getSeId(systemEnvironment))) continue;
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402082327", "The parameter $1 is referenced by $2", this.getName(systemEnvironment), sDMSParameterDefinition.getURL(systemEnvironment)));
        }
        if (this.getIsLong(systemEnvironment).booleanValue()) {
            this.deleteExtents(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public String getDefaultValue(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = super.getDefaultValue(systemEnvironment);
        if (this.getIsLong(systemEnvironment).booleanValue()) {
            Vector vector = SDMSVersionedExtentsTable.idx_oId.getVector(systemEnvironment, this.getId(systemEnvironment));
            for (int i = 1; i <= vector.size(); ++i) {
                for (int j = 0; j < vector.size(); ++j) {
                    SDMSVersionedExtents sDMSVersionedExtents = (SDMSVersionedExtents)vector.get(j);
                    if (i != sDMSVersionedExtents.getSequence(systemEnvironment)) continue;
                    string = string + sDMSVersionedExtents.getExtent(systemEnvironment);
                }
            }
        }
        return string;
    }

    private void createExtents(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        int n = 1;
        while (string.length() > 0) {
            if (string.length() <= SDMSVersionedExtentsProxyGeneric.getExtentMaxLength()) {
                SDMSVersionedExtentsTable.table.create(systemEnvironment, this.getId(systemEnvironment), n, string);
                break;
            }
            SDMSVersionedExtentsTable.table.create(systemEnvironment, this.getId(systemEnvironment), n, string.substring(0, SDMSVersionedExtentsProxyGeneric.getExtentMaxLength()));
            string = string.substring(SDMSVersionedExtentsProxyGeneric.getExtentMaxLength());
            ++n;
        }
    }

    @Override
    public void setDefaultValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        String string2 = this.getDefaultValue(systemEnvironment);
        if (string != null && string.equals(string2)) {
            return;
        }
        if (string == null && string2 == null) {
            return;
        }
        if (string != null) {
            if (this.getIsLong(systemEnvironment).booleanValue()) {
                this.deleteExtents(systemEnvironment);
            }
            if (string.length() > SDMSParameterDefinition.getDefaultValueMaxLength()) {
                this.createExtents(systemEnvironment, string.substring(SDMSParameterDefinition.getDefaultValueMaxLength()));
                string = string.substring(0, SDMSParameterDefinition.getDefaultValueMaxLength());
                this.setIsLong(systemEnvironment, Boolean.TRUE);
            } else {
                this.setIsLong(systemEnvironment, Boolean.FALSE);
            }
        }
        super.setDefaultValue(systemEnvironment, string);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        Long l = this.getSeId(systemEnvironment);
        try {
            sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        }
        catch (NotFoundException notFoundException) {
            try {
                sDMSProxy = SDMSScopeTable.getObject(systemEnvironment, l);
            }
            catch (NotFoundException notFoundException2) {
                try {
                    sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, l);
                }
                catch (NotFoundException notFoundException3) {
                    sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, l);
                }
            }
        }
        return this.getName(systemEnvironment) + " of " + sDMSProxy.getURL(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "parameter " + this.getURLName(systemEnvironment);
    }

    @Override
    public void setLinkPdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        super.setLinkPdId(systemEnvironment, l);
        this.checkRefCycle(systemEnvironment);
    }

    protected void checkRefCycle(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRefCycle(systemEnvironment, new HashSet<Long>());
    }

    protected void checkRefCycle(SystemEnvironment systemEnvironment, HashSet<Long> hashSet) throws SDMSException {
        Long l = this.getLinkPdId(systemEnvironment);
        if (l == null) {
            return;
        }
        hashSet.add(this.getId(systemEnvironment));
        if (hashSet.contains(l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03507140909", "Cyclic Parameter References detected"));
        }
        SDMSParameterDefinition sDMSParameterDefinition = SDMSParameterDefinitionTable.getObject(systemEnvironment, l);
        sDMSParameterDefinition.checkRefCycle(systemEnvironment, hashSet);
    }
}

