/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigGeneric;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSPoolDistConfigProxyGeneric
extends SDMSProxy {
    public static final long privilegeMask = 0x210000111L;
    private static SDMSTable[] masterTables = null;

    protected SDMSPoolDistConfigProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSPoolDistConfig getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSPoolDistConfigTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSPoolDistConfig(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSPoolDistConfig)sDMSProxy;
    }

    public Long getPldId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getPldId(systemEnvironment);
    }

    public void setPldId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setPldId(systemEnvironment, l);
    }

    public Long getPrId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getPrId(systemEnvironment);
    }

    public void setPrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setPrId(systemEnvironment, l);
    }

    public Boolean getIsManaged(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getIsManaged(systemEnvironment);
    }

    public void setIsManaged(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setIsManaged(systemEnvironment, bl);
    }

    public Integer getNomPct(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getNomPct(systemEnvironment);
    }

    public void setNomPct(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setNomPct(systemEnvironment, n);
    }

    public Integer getFreePct(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getFreePct(systemEnvironment);
    }

    public void setFreePct(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setFreePct(systemEnvironment, n);
    }

    public Integer getMinPct(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getMinPct(systemEnvironment);
    }

    public void setMinPct(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setMinPct(systemEnvironment, n);
    }

    public Integer getMaxPct(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getMaxPct(systemEnvironment);
    }

    public void setMaxPct(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setMaxPct(systemEnvironment, n);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSPoolDistConfig setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSPoolDistConfig)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSPoolDistConfigGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSPoolDistConfig setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSPoolDistConfig)this;
    }

    public SDMSPoolDistConfig set_PldIdPrId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        this.touchMaster(systemEnvironment);
        ((SDMSPoolDistConfigGeneric)this.object).set_PldIdPrId(systemEnvironment, l, l2);
        return (SDMSPoolDistConfig)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        bl = false;
        Long l2 = this.getPldId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSPoolDistributionTable.getObject(systemEnvironment, l2).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        bl = false;
        Long l3 = this.getPrId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSPooledResourceTable.getObject(systemEnvironment, l3).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        this.touchMaster(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x210000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x210000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x210000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l2 = 0L;
        l2 = l;
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL_DISTRIBUTION");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getPldId(systemEnvironment));
            long l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x210000111L, false, vector);
            if ((l3 & 0x100L) == 256L) {
                l3 |= 0x10000011L;
            }
            l2 &= l3;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing PoolDistConfig $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "POOL_DISTRIBUTION");
        try {
            SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getPldId(systemEnvironment));
            sDMSProxy.touch(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSPoolDistConfigGeneric)this.object).print();
    }
}

