/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolTableGeneric;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSPoolGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_nrId = 2;
    public static final int nr_scopeId = 3;
    public static final int nr_ownerId = 4;
    public static final int nr_managerId = 5;
    public static final int nr_distId = 6;
    public static final int nr_definedAmount = 7;
    public static final int nr_amount = 8;
    public static final int nr_freeAmount = 9;
    public static final int nr_childAllocated = 10;
    public static final int nr_evaluationCycle = 11;
    public static final int nr_nextEvaluationTime = 12;
    public static final int nr_tag = 13;
    public static final int nr_traceInterval = 14;
    public static final int nr_traceBase = 15;
    public static final int nr_traceBaseMultiplier = 16;
    public static final int nr_td0Avg = 17;
    public static final int nr_td1Avg = 18;
    public static final int nr_td2Avg = 19;
    public static final int nr_lwAvg = 20;
    public static final int nr_lastEval = 21;
    public static final int nr_lastWrite = 22;
    public static final int nr_creatorUId = 23;
    public static final int nr_createTs = 24;
    public static final int nr_changerUId = 25;
    public static final int nr_changeTs = 26;
    public static String tableName = "POOL";
    protected Long nrId;
    protected Long scopeId;
    protected Long ownerId;
    protected Long managerId;
    protected Long distId;
    protected Integer definedAmount;
    protected Integer amount;
    protected Integer freeAmount;
    protected Integer childAllocated;
    protected Integer evaluationCycle;
    protected Long nextEvaluationTime;
    protected String tag;
    protected Integer traceInterval;
    protected Integer traceBase;
    protected Integer traceBaseMultiplier;
    protected Float td0Avg;
    protected Float td1Avg;
    protected Float td2Avg;
    protected Float lwAvg;
    protected Long lastEval;
    protected Long lastWrite;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSPoolGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Long l6, String string, Integer n6, Integer n7, Integer n8, Float f, Float f2, Float f3, Float f4, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12) throws SDMSException {
        super(systemEnvironment, SDMSPoolTableGeneric.table);
        this.nrId = l;
        this.scopeId = l2;
        this.ownerId = l3;
        this.managerId = l4;
        this.distId = l5;
        this.definedAmount = n;
        this.amount = n2;
        this.freeAmount = n3;
        this.childAllocated = n4;
        this.evaluationCycle = n5;
        this.nextEvaluationTime = l6;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Pool) Length of $1 exceeds maximum length $2", "tag", "64"));
        }
        this.tag = string;
        this.traceInterval = n6;
        this.traceBase = n7;
        this.traceBaseMultiplier = n8;
        this.td0Avg = f;
        this.td1Avg = f2;
        this.td2Avg = f3;
        this.lwAvg = f4;
        this.lastEval = l7;
        this.lastWrite = l8;
        this.creatorUId = l9;
        this.createTs = l10;
        this.changerUId = l11;
        this.changeTs = l12;
    }

    public Long getNrId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nrId;
    }

    public void setNrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.nrId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
            }
            SDMSPoolGeneric sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
            sDMSPoolGeneric.nrId = l;
            sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 33L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getScopeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.scopeId;
    }

    public void setScopeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.scopeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
            }
            SDMSPoolGeneric sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
            sDMSPoolGeneric.scopeId = l;
            sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 34L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
            }
            SDMSPoolGeneric sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
            sDMSPoolGeneric.ownerId = l;
            sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getManagerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.managerId;
    }

    public void setManagerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.managerId)) {
            return;
        }
        if (l == null && this.managerId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
            }
            SDMSPoolGeneric sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
            sDMSPoolGeneric.managerId = l;
            sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getDistId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.distId;
    }

    public void setDistId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.distId)) {
            return;
        }
        if (l == null && this.distId == null) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.distId = l;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Integer getDefinedAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.definedAmount;
    }

    public void setDefinedAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.definedAmount.equals(n)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.definedAmount = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.amount;
    }

    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.amount.equals(n)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.amount = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Integer getFreeAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.freeAmount;
    }

    public void setFreeAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.freeAmount.equals(n)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.freeAmount = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Integer getChildAllocated(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.childAllocated;
    }

    public void setChildAllocated(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.childAllocated.equals(n)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.childAllocated = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Integer getEvaluationCycle(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.evaluationCycle;
    }

    public void setEvaluationCycle(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.evaluationCycle)) {
            return;
        }
        if (n == null && this.evaluationCycle == null) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.evaluationCycle = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Long getNextEvaluationTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nextEvaluationTime;
    }

    public void setNextEvaluationTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.nextEvaluationTime.equals(l)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.nextEvaluationTime = l;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public String getTag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.tag;
    }

    public void setTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.tag)) {
            return;
        }
        if (string == null && this.tag == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
            }
            SDMSPoolGeneric sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Pool) Length of $1 exceeds maximum length $2", "tag", "64"));
            }
            sDMSPoolGeneric.tag = string;
            sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getTraceInterval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.traceInterval;
    }

    public void setTraceInterval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.traceInterval)) {
            return;
        }
        if (n == null && this.traceInterval == null) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.traceInterval = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Integer getTraceBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.traceBase;
    }

    public void setTraceBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.traceBase)) {
            return;
        }
        if (n == null && this.traceBase == null) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.traceBase = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Integer getTraceBaseMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.traceBaseMultiplier;
    }

    public void setTraceBaseMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.traceBaseMultiplier.equals(n)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.traceBaseMultiplier = n;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Float getTd0Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.td0Avg;
    }

    public void setTd0Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.td0Avg.equals(f)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.td0Avg = f;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Float getTd1Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.td1Avg;
    }

    public void setTd1Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.td1Avg.equals(f)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.td1Avg = f;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Float getTd2Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.td2Avg;
    }

    public void setTd2Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.td2Avg.equals(f)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.td2Avg = f;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Float getLwAvg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lwAvg;
    }

    public void setLwAvg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.lwAvg.equals(f)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.lwAvg = f;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Long getLastEval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lastEval;
    }

    public void setLastEval(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.lastEval.equals(l)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.lastEval = l;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Long getLastWrite(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lastWrite;
    }

    public void setLastWrite(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.lastWrite.equals(l)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.lastWrite = l;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.creatorUId = l;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Pool) Change of system object not allowed"));
        }
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.createTs = l;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.changerUId = l;
        sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSPoolGeneric sDMSPoolGeneric = this;
        if (sDMSPoolGeneric.versions.o_v == null || sDMSPoolGeneric.versions.o_v.size() == 0 || sDMSPoolGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
        }
        sDMSPoolGeneric.changeTs = l;
        sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSPoolGeneric != this) {
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric, 0L);
        }
    }

    public SDMSPoolGeneric set_NrIdScopeId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSPoolGeneric sDMSPoolGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Pool) Change of system object not allowed"));
            }
            sDMSPoolGeneric = (SDMSPoolGeneric)this.change(systemEnvironment);
            sDMSPoolGeneric.nrId = l;
            sDMSPoolGeneric.scopeId = l2;
            sDMSPoolGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSPoolGeneric.changeTs = systemEnvironment.txTime();
            sDMSPoolGeneric.versions.table.index(systemEnvironment, sDMSPoolGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSPoolGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSPool(this);
    }

    protected SDMSPoolGeneric(Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Long l7, String string, Integer n6, Integer n7, Integer n8, Float f, Float f2, Float f3, Float f4, Long l8, Long l9, Long l10, Long l11, Long l12, Long l13, long l14, long l15) {
        this.id = l;
        this.nrId = l2;
        this.scopeId = l3;
        this.ownerId = l4;
        this.managerId = l5;
        this.distId = l6;
        this.definedAmount = n;
        this.amount = n2;
        this.freeAmount = n3;
        this.childAllocated = n4;
        this.evaluationCycle = n5;
        this.nextEvaluationTime = l7;
        this.tag = string;
        this.traceInterval = n6;
        this.traceBase = n7;
        this.traceBaseMultiplier = n8;
        this.td0Avg = f;
        this.td1Avg = f2;
        this.td2Avg = f3;
        this.lwAvg = f4;
        this.lastEval = l8;
        this.lastWrite = l9;
        this.creatorUId = l10;
        this.createTs = l11;
        this.changerUId = l12;
        this.changeTs = l13;
        this.validFrom = l14;
        this.validTo = l15;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "POOL" + string3 + " (ID, " + string2 + "NR_ID" + string3 + ", " + string2 + "SCOPE_ID" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "MANAGER_ID" + string3 + ", " + string2 + "DIST_ID" + string3 + ", " + string2 + "DEFINED_AMOUNT" + string3 + ", " + string2 + "AMOUNT" + string3 + ", " + string2 + "FREE_AMOUNT" + string3 + ", " + string2 + "CHILD_ALLOCATED" + string3 + ", " + string2 + "EVALUATION_CYCLE" + string3 + ", " + string2 + "NEXT_EVALUATION_TIME" + string3 + ", " + string2 + "TAG" + string3 + ", " + string2 + "TRACE_INTERVAL" + string3 + ", " + string2 + "TRACE_BASE" + string3 + ", " + string2 + "TRACE_BASE_MULTIPLIER" + string3 + ", " + string2 + "TD0_AVG" + string3 + ", " + string2 + "TD1_AVG" + string3 + ", " + string2 + "TD2_AVG" + string3 + ", " + string2 + "LW_AVG" + string3 + ", " + string2 + "LAST_EVAL" + string3 + ", " + string2 + "LAST_WRITE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSPoolGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Pool: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.nrId);
            preparedStatement.setLong(3, this.scopeId);
            preparedStatement.setLong(4, this.ownerId);
            if (this.managerId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.managerId);
            }
            if (this.distId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.distId);
            }
            preparedStatement.setInt(7, this.definedAmount);
            preparedStatement.setInt(8, this.amount);
            preparedStatement.setInt(9, this.freeAmount);
            preparedStatement.setInt(10, this.childAllocated);
            if (this.evaluationCycle == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.evaluationCycle);
            }
            preparedStatement.setLong(12, this.nextEvaluationTime);
            if (this.tag == null) {
                preparedStatement.setNull(13, 12);
            } else {
                preparedStatement.setString(13, this.tag);
            }
            if (this.traceInterval == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.traceInterval);
            }
            if (this.traceBase == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setInt(15, this.traceBase);
            }
            preparedStatement.setInt(16, this.traceBaseMultiplier);
            preparedStatement.setFloat(17, this.td0Avg.floatValue());
            preparedStatement.setFloat(18, this.td1Avg.floatValue());
            preparedStatement.setFloat(19, this.td2Avg.floatValue());
            preparedStatement.setFloat(20, this.lwAvg.floatValue());
            preparedStatement.setLong(21, this.lastEval);
            preparedStatement.setLong(22, this.lastWrite);
            preparedStatement.setLong(23, this.creatorUId);
            preparedStatement.setLong(24, this.createTs);
            preparedStatement.setLong(25, this.changerUId);
            preparedStatement.setLong(26, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Pool: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "POOL" + string3 + " WHERE ID = ?";
                SDMSPoolGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Pool: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Pool: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "POOL" + string3 + " SET " + string2 + "NR_ID" + string3 + " = ? , " + string2 + "SCOPE_ID" + string3 + " = ? , " + string2 + "OWNER_ID" + string3 + " = ? , " + string2 + "MANAGER_ID" + string3 + " = ? , " + string2 + "DIST_ID" + string3 + " = ? , " + string2 + "DEFINED_AMOUNT" + string3 + " = ? , " + string2 + "AMOUNT" + string3 + " = ? , " + string2 + "FREE_AMOUNT" + string3 + " = ? , " + string2 + "CHILD_ALLOCATED" + string3 + " = ? , " + string2 + "EVALUATION_CYCLE" + string3 + " = ? , " + string2 + "NEXT_EVALUATION_TIME" + string3 + " = ? , " + string2 + "TAG" + string3 + " = ? , " + string2 + "TRACE_INTERVAL" + string3 + " = ? , " + string2 + "TRACE_BASE" + string3 + " = ? , " + string2 + "TRACE_BASE_MULTIPLIER" + string3 + " = ? , " + string2 + "TD0_AVG" + string3 + " = ? , " + string2 + "TD1_AVG" + string3 + " = ? , " + string2 + "TD2_AVG" + string3 + " = ? , " + string2 + "LW_AVG" + string3 + " = ? , " + string2 + "LAST_EVAL" + string3 + " = ? , " + string2 + "LAST_WRITE" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSPoolGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Pool: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.nrId);
            preparedStatement.setLong(2, this.scopeId);
            preparedStatement.setLong(3, this.ownerId);
            if (this.managerId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.managerId);
            }
            if (this.distId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.distId);
            }
            preparedStatement.setInt(6, this.definedAmount);
            preparedStatement.setInt(7, this.amount);
            preparedStatement.setInt(8, this.freeAmount);
            preparedStatement.setInt(9, this.childAllocated);
            if (this.evaluationCycle == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.evaluationCycle);
            }
            preparedStatement.setLong(11, this.nextEvaluationTime);
            if (this.tag == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.tag);
            }
            if (this.traceInterval == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.traceInterval);
            }
            if (this.traceBase == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.traceBase);
            }
            preparedStatement.setInt(15, this.traceBaseMultiplier);
            preparedStatement.setFloat(16, this.td0Avg.floatValue());
            preparedStatement.setFloat(17, this.td1Avg.floatValue());
            preparedStatement.setFloat(18, this.td2Avg.floatValue());
            preparedStatement.setFloat(19, this.lwAvg.floatValue());
            preparedStatement.setLong(20, this.lastEval);
            preparedStatement.setLong(21, this.lastWrite);
            preparedStatement.setLong(22, this.creatorUId);
            preparedStatement.setLong(23, this.createTs);
            preparedStatement.setLong(24, this.changerUId);
            preparedStatement.setLong(25, this.changeTs);
            preparedStatement.setLong(26, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Pool: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Pool", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "nrId : " + this.nrId, 2);
        SDMSThread.doTrace(null, "scopeId : " + this.scopeId, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "managerId : " + this.managerId, 2);
        SDMSThread.doTrace(null, "distId : " + this.distId, 2);
        SDMSThread.doTrace(null, "definedAmount : " + this.definedAmount, 2);
        SDMSThread.doTrace(null, "amount : " + this.amount, 2);
        SDMSThread.doTrace(null, "freeAmount : " + this.freeAmount, 2);
        SDMSThread.doTrace(null, "childAllocated : " + this.childAllocated, 2);
        SDMSThread.doTrace(null, "evaluationCycle : " + this.evaluationCycle, 2);
        SDMSThread.doTrace(null, "nextEvaluationTime : " + this.nextEvaluationTime, 2);
        SDMSThread.doTrace(null, "tag : " + this.tag, 2);
        SDMSThread.doTrace(null, "traceInterval : " + this.traceInterval, 2);
        SDMSThread.doTrace(null, "traceBase : " + this.traceBase, 2);
        SDMSThread.doTrace(null, "traceBaseMultiplier : " + this.traceBaseMultiplier, 2);
        SDMSThread.doTrace(null, "td0Avg : " + this.td0Avg, 2);
        SDMSThread.doTrace(null, "td1Avg : " + this.td1Avg, 2);
        SDMSThread.doTrace(null, "td2Avg : " + this.td2Avg, 2);
        SDMSThread.doTrace(null, "lwAvg : " + this.lwAvg, 2);
        SDMSThread.doTrace(null, "lastEval : " + this.lastEval, 2);
        SDMSThread.doTrace(null, "lastWrite : " + this.lastWrite, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "nrId                : " + this.nrId + "\n" + string + "scopeId             : " + this.scopeId + "\n" + string + "ownerId             : " + this.ownerId + "\n" + string + "managerId           : " + this.managerId + "\n" + string + "distId              : " + this.distId + "\n" + string + "definedAmount       : " + this.definedAmount + "\n" + string + "amount              : " + this.amount + "\n" + string + "freeAmount          : " + this.freeAmount + "\n" + string + "childAllocated      : " + this.childAllocated + "\n" + string + "evaluationCycle     : " + this.evaluationCycle + "\n" + string + "nextEvaluationTime  : " + this.nextEvaluationTime + "\n" + string + "tag                 : " + this.tag + "\n" + string + "traceInterval       : " + this.traceInterval + "\n" + string + "traceBase           : " + this.traceBase + "\n" + string + "traceBaseMultiplier : " + this.traceBaseMultiplier + "\n" + string + "td0Avg              : " + this.td0Avg + "\n" + string + "td1Avg              : " + this.td1Avg + "\n" + string + "td2Avg              : " + this.td2Avg + "\n" + string + "lwAvg               : " + this.lwAvg + "\n" + string + "lastEval            : " + this.lastEval + "\n" + string + "lastWrite           : " + this.lastWrite + "\n" + string + "creatorUId          : " + this.creatorUId + "\n" + string + "createTs            : " + this.createTs + "\n" + string + "changerUId          : " + this.changerUId + "\n" + string + "changeTs            : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

