/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.HashMap;
import java.util.Vector;

public class SDMSResourceTemplateProxyGeneric
extends SDMSProxy {
    public static final long privilegeMask = 8858370329L;

    protected SDMSResourceTemplateProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSResourceTemplate getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSResourceTemplateTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSResourceTemplate(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSResourceTemplate)sDMSProxy;
    }

    public Long getNrId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getNrId(systemEnvironment);
    }

    public void setNrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setNrId(systemEnvironment, l);
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getSeId(systemEnvironment);
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setSeId(systemEnvironment, l);
    }

    @Override
    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getOwnerId(systemEnvironment);
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setOwnerId(systemEnvironment, l);
    }

    public Long getRsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getRsdId(systemEnvironment);
    }

    public void setRsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setRsdId(systemEnvironment, l);
    }

    public Integer getRequestableAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getRequestableAmount(systemEnvironment);
    }

    public void setRequestableAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setRequestableAmount(systemEnvironment, n);
    }

    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getAmount(systemEnvironment);
    }

    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setAmount(systemEnvironment, n);
    }

    public Boolean getIsOnline(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getIsOnline(systemEnvironment);
    }

    public void setIsOnline(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setIsOnline(systemEnvironment, bl);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSResourceTemplate setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSResourceTemplateGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSResourceTemplate)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceTemplateGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceTemplateGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSResourceTemplate setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSResourceTemplateGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSResourceTemplate)this;
    }

    public SDMSResourceTemplate set_NrIdSeId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        ((SDMSResourceTemplateGeneric)this.object).set_NrIdSeId(systemEnvironment, l, l2);
        return (SDMSResourceTemplate)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        bl = false;
        Long l2 = this.getNrId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSNamedResourceTable.getObject(systemEnvironment, l2).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        bl = false;
        Long l3 = this.getSeId(systemEnvironment);
        if (!bl) {
            try {
                sDMSKey.add(SDMSSchedulingEntityTable.getObject(systemEnvironment, l3).getSortKey(systemEnvironment));
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            sDMSGrant.setDeleteVersion(systemEnvironment, systemEnvironment.tx.txId);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l, long l2) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null, l2) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 8858370329L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370329L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370329L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l2 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l2 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l2 == l) {
                    return l2;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l2 |= sDMSGrant.getPrivs(systemEnvironment).longValue();
                        l2 = this.addImplicitPrivs(l2) & l;
                        if (l2 != l) continue;
                        return l2;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return l2;
    }

    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370329L, false, null, l));
    }

    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370329L, false, vector, l));
    }

    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l3 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l3 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l3 == l) {
                    return l3;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l3 |= sDMSGrant.getPrivs(systemEnvironment).longValue();
                        l3 = this.addImplicitPrivs(l3) & l;
                        if (l3 != l) continue;
                        return l3;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return l3;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing ResourceTemplate $1", this.getId(systemEnvironment));
        return sDMSMessage;
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSResourceTemplateGeneric)this.object).print();
    }
}

