/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import de.independit.scheduler.server.repository.SDMSSystemMessageTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSSystemMessageGeneric
extends SDMSObject
implements Cloneable {
    public static final int CANCEL = 1;
    public static final int RERUN = 2;
    public static final int ENABLE = 3;
    public static final int SET_STATE = 4;
    public static final int IGN_DEPENDENCY = 5;
    public static final int IGN_RESOURCE = 6;
    public static final int CLONE = 7;
    public static final int MODIFY_PARAMETER = 11;
    public static final int KILL = 12;
    public static final int SET_JOB_STATE = 13;
    public static final int DISABLE = 23;
    public static final int APPROVAL = 1;
    public static final int nr_id = 1;
    public static final int nr_msgType = 2;
    public static final int nr_smeId = 3;
    public static final int nr_masterId = 4;
    public static final int nr_operation = 5;
    public static final int nr_isMandatory = 6;
    public static final int nr_requestUId = 7;
    public static final int nr_requestTs = 8;
    public static final int nr_requestMsg = 9;
    public static final int nr_additionalLong = 10;
    public static final int nr_additionalBool = 11;
    public static final int nr_secondLong = 12;
    public static final int nr_comment = 13;
    public static final int nr_creatorUId = 14;
    public static final int nr_createTs = 15;
    public static final int nr_changerUId = 16;
    public static final int nr_changeTs = 17;
    public static String tableName = "SYSTEM_MESSAGE";
    protected Integer msgType;
    protected Long smeId;
    protected Long masterId;
    protected Integer operation;
    protected Boolean isMandatory;
    protected Long requestUId;
    protected Long requestTs;
    protected String requestMsg;
    protected Long additionalLong;
    protected Boolean additionalBool;
    protected Long secondLong;
    protected String comment;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSSystemMessageGeneric(SystemEnvironment systemEnvironment, Integer n, Long l, Long l2, Integer n2, Boolean bl, Long l3, Long l4, String string, Long l5, Boolean bl2, Long l6, String string2, Long l7, Long l8, Long l9, Long l10) throws SDMSException {
        super(systemEnvironment, SDMSSystemMessageTableGeneric.table);
        this.msgType = n;
        this.smeId = l;
        this.masterId = l2;
        this.operation = n2;
        this.isMandatory = bl;
        this.requestUId = l3;
        this.requestTs = l4;
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SystemMessage) Length of $1 exceeds maximum length $2", "requestMsg", "512"));
        }
        this.requestMsg = string;
        this.additionalLong = l5;
        this.additionalBool = bl2;
        this.secondLong = l6;
        if (string2 != null && string2.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SystemMessage) Length of $1 exceeds maximum length $2", "comment", "1024"));
        }
        this.comment = string2;
        this.creatorUId = l7;
        this.createTs = l8;
        this.changerUId = l9;
        this.changeTs = l10;
    }

    public Integer getMsgType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.msgType;
    }

    public String getMsgTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getMsgType(systemEnvironment);
        switch (n) {
            case 1: {
                return "APPROVAL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SystemMessage.msgType: $1", this.getMsgType(systemEnvironment)));
    }

    public void setMsgType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.msgType.equals(n)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.msgType = n;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
            }
            SDMSSystemMessageGeneric sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
            sDMSSystemMessageGeneric.smeId = l;
            sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getMasterId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.masterId;
    }

    public void setMasterId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.masterId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
            }
            SDMSSystemMessageGeneric sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
            sDMSSystemMessageGeneric.masterId = l;
            sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getOperation(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.operation;
    }

    public String getOperationAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getOperation(systemEnvironment);
        switch (n) {
            case 1: {
                return "CANCEL";
            }
            case 2: {
                return "RERUN";
            }
            case 3: {
                return "ENABLE";
            }
            case 4: {
                return "SET_STATE";
            }
            case 5: {
                return "IGN_DEPENDENCY";
            }
            case 6: {
                return "IGN_RESOURCE";
            }
            case 7: {
                return "CLONE";
            }
            case 11: {
                return "MODIFY_PARAMETER";
            }
            case 12: {
                return "KILL";
            }
            case 23: {
                return "DISABLE";
            }
            case 13: {
                return "SET_JOB_STATE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown SystemMessage.operation: $1", this.getOperation(systemEnvironment)));
    }

    public void setOperation(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.operation.equals(n)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.operation = n;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Boolean getIsMandatory(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isMandatory;
    }

    public void setIsMandatory(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isMandatory.equals(bl)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.isMandatory = bl;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getRequestUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.requestUId;
    }

    public void setRequestUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.requestUId.equals(l)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.requestUId = l;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getRequestTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.requestTs;
    }

    public void setRequestTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.requestTs.equals(l)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.requestTs = l;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public String getRequestMsg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.requestMsg;
    }

    public void setRequestMsg(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.requestMsg)) {
            return;
        }
        if (string == null && this.requestMsg == null) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SystemMessage) Length of $1 exceeds maximum length $2", "requestMsg", "512"));
        }
        sDMSSystemMessageGeneric.requestMsg = string;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getAdditionalLong(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.additionalLong;
    }

    public void setAdditionalLong(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.additionalLong)) {
            return;
        }
        if (l == null && this.additionalLong == null) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.additionalLong = l;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Boolean getAdditionalBool(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.additionalBool;
    }

    public void setAdditionalBool(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.additionalBool)) {
            return;
        }
        if (bl == null && this.additionalBool == null) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.additionalBool = bl;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getSecondLong(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.secondLong;
    }

    public void setSecondLong(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.secondLong)) {
            return;
        }
        if (l == null && this.secondLong == null) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.secondLong = l;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public String getComment(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.comment;
    }

    public void setComment(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.comment)) {
            return;
        }
        if (string == null && this.comment == null) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1024) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SystemMessage) Length of $1 exceeds maximum length $2", "comment", "1024"));
        }
        sDMSSystemMessageGeneric.comment = string;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.creatorUId = l;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SystemMessage) Change of system object not allowed"));
        }
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.createTs = l;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.changerUId = l;
        sDMSSystemMessageGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSSystemMessageGeneric sDMSSystemMessageGeneric = this;
        if (sDMSSystemMessageGeneric.versions.o_v == null || sDMSSystemMessageGeneric.versions.o_v.size() == 0 || sDMSSystemMessageGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSystemMessageGeneric = (SDMSSystemMessageGeneric)this.change(systemEnvironment);
        }
        sDMSSystemMessageGeneric.changeTs = l;
        sDMSSystemMessageGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSSystemMessageGeneric != this) {
            sDMSSystemMessageGeneric.versions.table.index(systemEnvironment, sDMSSystemMessageGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSSystemMessage(this);
    }

    protected SDMSSystemMessageGeneric(Long l, Integer n, Long l2, Long l3, Integer n2, Boolean bl, Long l4, Long l5, String string, Long l6, Boolean bl2, Long l7, String string2, Long l8, Long l9, Long l10, Long l11, long l12, long l13) {
        this.id = l;
        this.msgType = n;
        this.smeId = l2;
        this.masterId = l3;
        this.operation = n2;
        this.isMandatory = bl;
        this.requestUId = l4;
        this.requestTs = l5;
        this.requestMsg = string;
        this.additionalLong = l6;
        this.additionalBool = bl2;
        this.secondLong = l7;
        this.comment = string2;
        this.creatorUId = l8;
        this.createTs = l9;
        this.changerUId = l10;
        this.changeTs = l11;
        this.validFrom = l12;
        this.validTo = l13;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SYSTEM_MESSAGE" + string3 + " (ID, " + string2 + "MSG_TYPE" + string3 + ", " + string2 + "SME_ID" + string3 + ", " + string2 + "MASTER_ID" + string3 + ", " + string2 + "OPERATION" + string3 + ", " + string2 + "IS_MANDATORY" + string3 + ", " + string2 + "REQUEST_U_ID" + string3 + ", " + string2 + "REQUEST_TS" + string3 + ", " + string2 + "REQUEST_MSG" + string3 + ", " + string2 + "ADDITIONAL_LONG" + string3 + ", " + string2 + "ADDITIONAL_BOOL" + string3 + ", " + string2 + "SECOND_LONG" + string3 + ", " + string2 + "COMMENT" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSSystemMessageGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "SystemMessage: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setInt(2, this.msgType);
            preparedStatement.setLong(3, this.smeId);
            preparedStatement.setLong(4, this.masterId);
            preparedStatement.setInt(5, this.operation);
            preparedStatement.setInt(6, this.isMandatory != false ? 1 : 0);
            preparedStatement.setLong(7, this.requestUId);
            preparedStatement.setLong(8, this.requestTs);
            if (this.requestMsg == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.requestMsg);
            }
            if (this.additionalLong == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.additionalLong);
            }
            if (this.additionalBool == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.additionalBool != false ? 1 : 0);
            }
            if (this.secondLong == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setLong(12, this.secondLong);
            }
            if (this.comment == null) {
                preparedStatement.setNull(13, 12);
            } else {
                preparedStatement.setString(13, this.comment);
            }
            preparedStatement.setLong(14, this.creatorUId);
            preparedStatement.setLong(15, this.createTs);
            preparedStatement.setLong(16, this.changerUId);
            preparedStatement.setLong(17, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "SystemMessage: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "SYSTEM_MESSAGE" + string3 + " WHERE ID = ?";
                SDMSSystemMessageGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "SystemMessage: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "SystemMessage: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "SYSTEM_MESSAGE" + string3 + " SET " + string2 + "MSG_TYPE" + string3 + " = ? , " + string2 + "SME_ID" + string3 + " = ? , " + string2 + "MASTER_ID" + string3 + " = ? , " + string2 + "OPERATION" + string3 + " = ? , " + string2 + "IS_MANDATORY" + string3 + " = ? , " + string2 + "REQUEST_U_ID" + string3 + " = ? , " + string2 + "REQUEST_TS" + string3 + " = ? , " + string2 + "REQUEST_MSG" + string3 + " = ? , " + string2 + "ADDITIONAL_LONG" + string3 + " = ? , " + string2 + "ADDITIONAL_BOOL" + string3 + " = ? , " + string2 + "SECOND_LONG" + string3 + " = ? , " + string2 + "COMMENT" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSSystemMessageGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "SystemMessage: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, this.msgType);
            preparedStatement.setLong(2, this.smeId);
            preparedStatement.setLong(3, this.masterId);
            preparedStatement.setInt(4, this.operation);
            preparedStatement.setInt(5, this.isMandatory != false ? 1 : 0);
            preparedStatement.setLong(6, this.requestUId);
            preparedStatement.setLong(7, this.requestTs);
            if (this.requestMsg == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.requestMsg);
            }
            if (this.additionalLong == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.additionalLong);
            }
            if (this.additionalBool == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.additionalBool != false ? 1 : 0);
            }
            if (this.secondLong == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setLong(11, this.secondLong);
            }
            if (this.comment == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.comment);
            }
            preparedStatement.setLong(13, this.creatorUId);
            preparedStatement.setLong(14, this.createTs);
            preparedStatement.setLong(15, this.changerUId);
            preparedStatement.setLong(16, this.changeTs);
            preparedStatement.setLong(17, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "SystemMessage: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkMsgType(Integer n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkOperation(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : SystemMessage", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "msgType : " + this.msgType, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "masterId : " + this.masterId, 2);
        SDMSThread.doTrace(null, "operation : " + this.operation, 2);
        SDMSThread.doTrace(null, "isMandatory : " + this.isMandatory, 2);
        SDMSThread.doTrace(null, "requestUId : " + this.requestUId, 2);
        SDMSThread.doTrace(null, "requestTs : " + this.requestTs, 2);
        SDMSThread.doTrace(null, "requestMsg : " + this.requestMsg, 2);
        SDMSThread.doTrace(null, "additionalLong : " + this.additionalLong, 2);
        SDMSThread.doTrace(null, "additionalBool : " + this.additionalBool, 2);
        SDMSThread.doTrace(null, "secondLong : " + this.secondLong, 2);
        SDMSThread.doTrace(null, "comment : " + this.comment, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "msgType        : " + this.msgType + "\n" + string + "smeId          : " + this.smeId + "\n" + string + "masterId       : " + this.masterId + "\n" + string + "operation      : " + this.operation + "\n" + string + "isMandatory    : " + this.isMandatory + "\n" + string + "requestUId     : " + this.requestUId + "\n" + string + "requestTs      : " + this.requestTs + "\n" + string + "requestMsg     : " + this.requestMsg + "\n" + string + "additionalLong : " + this.additionalLong + "\n" + string + "additionalBool : " + this.additionalBool + "\n" + string + "secondLong     : " + this.secondLong + "\n" + string + "comment        : " + this.comment + "\n" + string + "creatorUId     : " + this.creatorUId + "\n" + string + "createTs       : " + this.createTs + "\n" + string + "changerUId     : " + this.changerUId + "\n" + string + "changeTs       : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

