/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSVersionedExtents;
import de.independit.scheduler.server.repository.SDMSVersionedExtentsTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSVersionedExtentsGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_oId = 2;
    public static final int nr_sequence = 3;
    public static final int nr_extent = 4;
    public static final int nr_creatorUId = 5;
    public static final int nr_createTs = 6;
    public static final int nr_changerUId = 7;
    public static final int nr_changeTs = 8;
    public static String tableName = "VERSIONED_EXTENTS";
    protected Long oId;
    protected Integer sequence;
    protected String extent;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSVersionedExtentsGeneric(SystemEnvironment systemEnvironment, Long l, Integer n, String string, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
        super(systemEnvironment, SDMSVersionedExtentsTableGeneric.table);
        this.oId = l;
        this.sequence = n;
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(VersionedExtents) Length of $1 exceeds maximum length $2", "extent", "256"));
        }
        this.extent = string;
        this.creatorUId = l2;
        this.createTs = l3;
        this.changerUId = l4;
        this.changeTs = l5;
    }

    public Long getOId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.oId;
    }

    public void setOId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.oId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(VersionedExtents) Change of system object not allowed"));
            }
            SDMSVersionedExtentsGeneric sDMSVersionedExtentsGeneric = (SDMSVersionedExtentsGeneric)this.change(systemEnvironment);
            sDMSVersionedExtentsGeneric.oId = l;
            sDMSVersionedExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSVersionedExtentsGeneric.changeTs = systemEnvironment.txTime();
            sDMSVersionedExtentsGeneric.versions.table.index(systemEnvironment, sDMSVersionedExtentsGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getSequence(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.sequence;
    }

    public void setSequence(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.sequence.equals(n)) {
            return;
        }
        SDMSVersionedExtentsGeneric sDMSVersionedExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(VersionedExtents) Change of system object not allowed"));
        }
        if (sDMSVersionedExtentsGeneric.versions.o_v == null || sDMSVersionedExtentsGeneric.versions.o_v.size() == 0 || sDMSVersionedExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSVersionedExtentsGeneric = (SDMSVersionedExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSVersionedExtentsGeneric.sequence = n;
        sDMSVersionedExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSVersionedExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSVersionedExtentsGeneric != this) {
            sDMSVersionedExtentsGeneric.versions.table.index(systemEnvironment, sDMSVersionedExtentsGeneric, 0L);
        }
    }

    public String getExtent(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.extent;
    }

    public void setExtent(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.extent.equals(string)) {
            return;
        }
        SDMSVersionedExtentsGeneric sDMSVersionedExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(VersionedExtents) Change of system object not allowed"));
        }
        if (sDMSVersionedExtentsGeneric.versions.o_v == null || sDMSVersionedExtentsGeneric.versions.o_v.size() == 0 || sDMSVersionedExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSVersionedExtentsGeneric = (SDMSVersionedExtentsGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(VersionedExtents) Length of $1 exceeds maximum length $2", "extent", "256"));
        }
        sDMSVersionedExtentsGeneric.extent = string;
        sDMSVersionedExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSVersionedExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSVersionedExtentsGeneric != this) {
            sDMSVersionedExtentsGeneric.versions.table.index(systemEnvironment, sDMSVersionedExtentsGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSVersionedExtentsGeneric sDMSVersionedExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(VersionedExtents) Change of system object not allowed"));
        }
        if (sDMSVersionedExtentsGeneric.versions.o_v == null || sDMSVersionedExtentsGeneric.versions.o_v.size() == 0 || sDMSVersionedExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSVersionedExtentsGeneric = (SDMSVersionedExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSVersionedExtentsGeneric.creatorUId = l;
        sDMSVersionedExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSVersionedExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSVersionedExtentsGeneric != this) {
            sDMSVersionedExtentsGeneric.versions.table.index(systemEnvironment, sDMSVersionedExtentsGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSVersionedExtentsGeneric sDMSVersionedExtentsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(VersionedExtents) Change of system object not allowed"));
        }
        if (sDMSVersionedExtentsGeneric.versions.o_v == null || sDMSVersionedExtentsGeneric.versions.o_v.size() == 0 || sDMSVersionedExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSVersionedExtentsGeneric = (SDMSVersionedExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSVersionedExtentsGeneric.createTs = l;
        sDMSVersionedExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSVersionedExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSVersionedExtentsGeneric != this) {
            sDMSVersionedExtentsGeneric.versions.table.index(systemEnvironment, sDMSVersionedExtentsGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSVersionedExtentsGeneric sDMSVersionedExtentsGeneric = this;
        if (sDMSVersionedExtentsGeneric.versions.o_v == null || sDMSVersionedExtentsGeneric.versions.o_v.size() == 0 || sDMSVersionedExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSVersionedExtentsGeneric = (SDMSVersionedExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSVersionedExtentsGeneric.changerUId = l;
        sDMSVersionedExtentsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSVersionedExtentsGeneric != this) {
            sDMSVersionedExtentsGeneric.versions.table.index(systemEnvironment, sDMSVersionedExtentsGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSVersionedExtentsGeneric sDMSVersionedExtentsGeneric = this;
        if (sDMSVersionedExtentsGeneric.versions.o_v == null || sDMSVersionedExtentsGeneric.versions.o_v.size() == 0 || sDMSVersionedExtentsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSVersionedExtentsGeneric = (SDMSVersionedExtentsGeneric)this.change(systemEnvironment);
        }
        sDMSVersionedExtentsGeneric.changeTs = l;
        sDMSVersionedExtentsGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSVersionedExtentsGeneric != this) {
            sDMSVersionedExtentsGeneric.versions.table.index(systemEnvironment, sDMSVersionedExtentsGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSVersionedExtents(this);
    }

    protected SDMSVersionedExtentsGeneric(Long l, Long l2, Integer n, String string, Long l3, Long l4, Long l5, Long l6, long l7, long l8) {
        this.id = l;
        this.oId = l2;
        this.sequence = n;
        this.extent = string;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
        this.validFrom = l7;
        this.validTo = l8;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "VERSIONED_EXTENTS" + string3 + " (ID, " + string2 + "O_ID" + string3 + ", " + string2 + "SEQUENCE" + string3 + ", " + string2 + "EXTENT" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSVersionedExtentsGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "VersionedExtents: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.oId);
            preparedStatement.setInt(3, this.sequence);
            preparedStatement.setString(4, this.extent);
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.setLong(9, systemEnvironment.tx.versionId);
            preparedStatement.setLong(10, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "VersionedExtents: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "VERSIONED_EXTENTS" + string4 + " SET VALID_TO = ?,     CHANGE_TS = ?,     CHANGER_U_ID = ? WHERE ID = ?  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSVersionedExtentsGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "VersionedExtents : $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "VersionedExtents: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : VersionedExtents", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "oId : " + this.oId, 2);
        SDMSThread.doTrace(null, "sequence : " + this.sequence, 2);
        SDMSThread.doTrace(null, "extent : " + this.extent, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "oId        : " + this.oId + "\n" + string + "sequence   : " + this.sequence + "\n" + string + "extent     : " + this.extent + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

