/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.tools;

import de.independit.scheduler.SDMSApp.App;
import de.independit.scheduler.SDMSApp.RetryException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputUtil;

class auto_restart
extends App {
    public static final String __version = "@(#) $Id: auto_restart.java,v 2.3.6.1 2013/03/14 10:25:30 ronald Exp $";
    public static final String FAILED = "FAILED";
    public static final String DELAY = "DELAY";
    public static final String MAX = "MAX";
    public static final String WARN = "WARNING";
    public static final String FORCE = "FORCE";

    @Override
    public void addOptions() {
        this.addOption("f", "failed", null, FAILED, null, "jobid", true, "Id of the failed job which might get restarted");
        this.addOption("d", "delay", null, DELAY, null, "minutes", false, "Default number of minutes the job should be delayed if job does not define AUTORESTART_DELAY");
        this.addOption("m", "max", null, MAX, null, "number", false, "Default max number of times the job should be restarted if job does not define AUTORESTART_MAX");
        this.addOption("W", "warn", null, WARN, null, null, false, "[Don't] Set Warning if maximum number of restarts was reached");
        this.addOption("F", "force", null, FORCE, null, null, false, "[Don't] Restart Jobs with state ERROR or BROKEN_FINISHED");
    }

    @Override
    public String getName() {
        return "auto_restart";
    }

    @Override
    public boolean userOnly() {
        return true;
    }

    @Override
    public boolean canRetry() {
        return true;
    }

    @Override
    public int go() throws RetryException {
        int n;
        String string = this.options.getValue(FAILED);
        String string2 = "GET PARAMETER OF " + string + " AUTORESTART LIBERAL";
        SDMSOutput sDMSOutput = this.execute(string2);
        if (sDMSOutput.error != null && !sDMSOutput.error.code.equals("03209231453")) {
            System.err.println("Error executing: " + string2);
            this.printError(sDMSOutput.error);
            return 1;
        }
        boolean bl = false;
        if (sDMSOutput.error == null && SDMSOutputUtil.getFromRecord(sDMSOutput, "VALUE").toUpperCase().equals("TRUE")) {
            bl = true;
        }
        if (!bl) {
            return 0;
        }
        if (!this.options.isSet(FORCE) || !this.options.getOption(FORCE).getBValue()) {
            string2 = "SHOW JOB " + string;
            sDMSOutput = this.execute(string2);
            if (sDMSOutput.error != null) {
                System.err.println("Error executing: " + string2);
                this.printError(sDMSOutput.error);
                return 1;
            }
            String string3 = SDMSOutputUtil.getFromRecord(sDMSOutput, "STATE");
            if (!string3.equals("FINISHED")) {
                System.err.println("Can't restart job " + string + " because it is not in a state FINISHED, but in state " + string3);
                return 1;
            }
        }
        int n2 = -1;
        if (this.options.isSet(MAX)) {
            n2 = Integer.parseInt(this.options.getValue(MAX));
        }
        string2 = "GET PARAMETER OF " + string + " AUTORESTART_MAX LIBERAL";
        sDMSOutput = this.execute(string2);
        if (sDMSOutput.error != null && !sDMSOutput.error.code.equals("03209231453")) {
            System.err.println("Error executing: " + string2);
            this.printError(sDMSOutput.error);
            return 1;
        }
        if (sDMSOutput.error == null) {
            n2 = Integer.parseInt(SDMSOutputUtil.getFromRecord(sDMSOutput, "VALUE"));
        }
        if (n2 != -1) {
            string2 = "GET PARAMETER OF " + string + " AUTORESTART_COUNT LIBERAL";
            sDMSOutput = this.execute(string2);
            if (sDMSOutput.error != null && !sDMSOutput.error.code.equals("03209231453")) {
                System.err.println("Error executing: " + string2);
                this.printError(sDMSOutput.error);
                return 1;
            }
            n = 0;
            if (sDMSOutput.error == null) {
                n = Integer.parseInt(SDMSOutputUtil.getFromRecord(sDMSOutput, "VALUE"));
            }
            if (n >= n2) {
                if (n == n2 && this.options.isSet(WARN) && this.options.getOption(WARN).getBValue()) {
                    string2 = "ALTER JOB " + string + " WITH WARNING = 'Maximum number of automatic restarts reached'";
                    sDMSOutput = this.execute(string2);
                    if (sDMSOutput.error != null) {
                        System.err.println("Error executing: " + string2);
                        this.printError(sDMSOutput.error);
                        return 1;
                    }
                    string2 = "SET PARAMETER OF " + string + " AUTORESTART_COUNT = '" + Integer.toString(n + 1) + "'";
                    sDMSOutput = this.execute(string2);
                    if (sDMSOutput.error != null) {
                        System.err.println("Error executing: " + string2);
                        this.printError(sDMSOutput.error);
                        return 1;
                    }
                }
                return 0;
            }
            string2 = "SET PARAMETER OF " + string + " AUTORESTART_COUNT = '" + Integer.toString(++n) + "'";
            sDMSOutput = this.execute(string2);
            if (sDMSOutput.error != null) {
                System.err.println("Error executing: " + string2);
                this.printError(sDMSOutput.error);
                return 1;
            }
        }
        n = 0;
        if (this.options.isSet(DELAY)) {
            n = Integer.parseInt(this.options.getValue(DELAY));
        }
        string2 = "GET PARAMETER OF " + string + " AUTORESTART_DELAY LIBERAL";
        sDMSOutput = this.execute(string2);
        if (sDMSOutput.error != null && !sDMSOutput.error.code.equals("03209231453")) {
            System.err.println("Error executing: " + string2);
            this.printError(sDMSOutput.error);
            return 1;
        }
        if (sDMSOutput.error == null) {
            n = Integer.parseInt(SDMSOutputUtil.getFromRecord(sDMSOutput, "VALUE"));
        }
        string2 = "ALTER JOB " + string + " WITH RERUN, COMMENT = 'auto_restart'";
        if (n > 0) {
            string2 = string2 + ", SUSPEND, RESUME IN " + Integer.toString(n) + " MINUTE";
        }
        sDMSOutput = this.execute(string2);
        if (sDMSOutput.error != null) {
            System.err.println("Error executing: " + string2);
            this.printError(sDMSOutput.error);
            return 1;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        System.exit(new auto_restart().run(stringArray));
    }
}

