@echo off

rem ---------------------------------------------------------------------
rem
rem      SETUP BICSUITE ENVIRONMENT
rem
rem ---------------------------------------------------------------------
set ERRORLEVEL=0
if not defined BICSUITEHOME goto undefined_bicsuitehome
if not defined BICSUITECONFIG set BICSUITECONFIG=%BICSUITEHOME%\etc

call "%BICSUITECONFIG%\JAVA_CONF.BAT"
if not %ERRORLEVEL% EQU 0 goto bad_java_conf

call "%BICSUITECONFIG%\BICSUITE_CONF.BAT"
if not %ERRORLEVEL% EQU 0 goto bad_bicsuite_conf


rem ---------------------------------------------------------------------
rem
rem      SET SOME VARIABLES
rem
rem ---------------------------------------------------------------------
set SRVNAME=bicsuite
if not defined SCROLLLOGOPTS goto noscrolllogopts
set SRVEXEC=\"%BICSUITEHOME%\bin\Scrolllog.exe\" %SCROLLLOGOPTS%
goto after_srvexec_def
:noscrolllogopts
set SRVEXEC=\"%BICSUITEHOME%\bin\Scrolllog.exe\"
:after_srvexec_def
set LOGDIR=%BICSUITELOGDIR%
if "%LOGDIR%"=="" set LOGDIR=%BICSUITEHOME%\log
set LOGNAME=%SRVNAME%
set SCRLLOG=%SRVNAME%.log
set WRKDIR=%BICSUITEHOME%
set SRVCMD=\"%BICSUITEJAVA_BS_SERVICE%\" %BICSUITEJAVAFLAGS_BS% -cp \"%BICSUITEHOME%\lib\BICsuite.jar;%BICSUITEJDBC%\" de.independit.scheduler.BICServer \"%BICSUITECONFIG%\server.conf\"
set SRVPARM=-c %SRVNAME%  \"%LOGDIR%\%LOGNAME%\" -o \"%LOGDIR%\%SCRLLOG%\" -e %SRVCMD% %SRVCMDP%
set SRVSTART=auto


rem ---------------------------------------------------------------------
rem
rem      OH GREAT MASTER, WHAT IS YOUR WISH?
rem
rem ---------------------------------------------------------------------
if "%1"=="install" goto install
if "%1"=="remove" goto remove
if "%1"=="delete" goto remove
if "%1"=="start" goto start
if "%1"=="stop" goto stop
if "%1"=="status" goto status
if "%1"=="reconfigure" goto reconfigure
echo "Usage: install.bat install|remove|start|stop|status|reconfigure"
exit /B 1

rem ---------------------------------------------------------------------
rem
rem      DELETE/REMOVE THE SERVICE
rem
rem ---------------------------------------------------------------------
:remove
sc.exe delete %SRVNAME%
exit /B %ERRORLEVEL%


rem ---------------------------------------------------------------------
rem
rem      INSTALL THE SERVICE
rem
rem ---------------------------------------------------------------------
:install
sc.exe create %SRVNAME% start= %SRVSTART% binpath= "%SRVEXEC% %SRVPARM%"
exit /B %ERRORLEVEL%


rem ---------------------------------------------------------------------
rem
rem      RECONFIGURE THE SERVICE
rem
rem ---------------------------------------------------------------------
:reconfigure
sc.exe query %SRVNAME% | find "RUNNING" >NUL
if not errorlevel 1 goto reconfigure_end

sc.exe config %SRVNAME% start= %SRVSTART% binpath= "%SRVEXEC% %SRVPARM%"
exit /B %ERRORLEVEL%
:reconfigure_end
echo It seems the service is still running. Stop it first
exit /B 1


rem ---------------------------------------------------------------------
rem
rem      START THE SERVICE
rem
rem ---------------------------------------------------------------------
:start
rem is BICsuite already running?
sc.exe query %SRVNAME% | find "RUNNING" >NUL
if not errorlevel 1 goto start_end
sc.exe start %SRVNAME%
exit /B %ERRORLEVEL%
:start_end
echo BICsuite is already running
exit /B 1


rem ---------------------------------------------------------------------
rem
rem      STOP THE SERVICE
rem
rem ---------------------------------------------------------------------
:stop
rem is BICsuite running in the first place?
sc.exe query %SRVNAME% | find "RUNNING" >NUL
if errorlevel 1 goto stop_end

rem try to shutdown service 
sc.exe stop %SRVNAME%
exit /B %ERRORLEVEL%

:stop_end
exit /B 0


rem ---------------------------------------------------------------------
rem
rem      GET THE STATUS OF THE SERVICE
rem
rem ---------------------------------------------------------------------
:status
sc.exe query %SRVNAME%
exit /B 0


rem ---------------------------------------------------------------------
rem
rem      SOME ERROR EXITS
rem
rem ---------------------------------------------------------------------
:undefined_bicsuitehome
ECHO Environment Variable BICSUITEHOME must be defined
exit /B 1

:bad_java_conf
ECHO Missing or invalid file %BICSUITECONFIG%\JAVA_CONF.BAT
exit /B 1

:bad_bicsuite_conf
ECHO Missing or invalid file %BICSUITECONFIG%\BICSUITE_CONF.BAT
exit /B 1
