-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE DEPENDENCY_INSTANCE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint          NOT NULL
    , DEPENDENT_ID                   bigint          NOT NULL
    , DEPENDENT_ID_ORIG              bigint          NOT NULL
    , DEPENDENCY_OPERATION           integer         NOT NULL
    , REQUIRED_ID                    bigint          NOT NULL
    , REQUIRED_SE_ID                 bigint              NULL
    , STATE                          integer         NOT NULL
    , IGNORE                         integer         NOT NULL
    , DI_ID_ORIG                     bigint          NOT NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_DEPENDENCY_INSTANCE
ON DEPENDENCY_INSTANCE(ID);
CREATE VIEW SCI_DEPENDENCY_INSTANCE AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , DEPENDENT_ID                   AS DEPENDENT_ID
    , DEPENDENT_ID_ORIG              AS DEPENDENT_ID_ORIG
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , REQUIRED_ID                    AS REQUIRED_ID
    , REQUIRED_SE_ID                 AS REQUIRED_SE_ID
    , DECODE (STATE, 0, 'OPEN', 1, 'FULFILLED', 2, 'FAILED', 3, 'BROKEN', 4, 'DEFERRED', 8, 'CANCELLED') AS STATE
    , DECODE (IGNORE, 0, 'NO', 1, 'YES', 2, 'RECURSIVE') AS IGNORE
    , DI_ID_ORIG                     AS DI_ID_ORIG
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM DEPENDENCY_INSTANCE;
CREATE TABLE ARC_DEPENDENCY_INSTANCE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint           NULL
    , DEPENDENT_ID                   bigint           NULL
    , DEPENDENT_ID_ORIG              bigint           NULL
    , DEPENDENCY_OPERATION           integer          NULL
    , REQUIRED_ID                    bigint           NULL
    , REQUIRED_SE_ID                 bigint           NULL
    , STATE                          integer          NULL
    , IGNORE                         integer          NULL
    , DI_ID_ORIG                     bigint           NULL
    , SE_VERSION                     bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
