-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE KILL_JOB (
    ID                             bigint NOT NULL
    , SE_ID                          bigint          NOT NULL
    , SE_VERSION                     bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SCOPE_ID                       bigint          NOT NULL
    , STATE                          int8            NOT NULL
    , EXIT_CODE                      int8                NULL
    , COMMANDLINE                    lvarchar(512)       NULL
    , LOGFILE                        lvarchar(512)       NULL
    , ERRLOGFILE                     lvarchar(512)       NULL
    , PID                            lvarchar(32)        NULL
    , EXTPID                         lvarchar(32)        NULL
    , ERROR_MSG                      lvarchar(256)       NULL
    , RUNNABLE_TS                    bigint              NULL
    , START_TS                       bigint              NULL
    , FINSH_TS                       bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_KILL_JOB
ON KILL_JOB(ID);
CREATE VIEW SCI_KILL_JOB (ID,SE_ID,SE_VERSION,SME_ID,SCOPE_ID,STATE,EXIT_CODE,COMMANDLINE,LOGFILE,ERRLOGFILE,PID,EXTPID,ERROR_MSG,RUNNABLE_TS,START_TS,FINSH_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , SE_VERSION                     AS SE_VERSION
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 11, 'FINISHED', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR') AS STATE
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINSH_TS, 1125899906842624)/1000)) AS FINSH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM KILL_JOB;
CREATE TABLE ARC_KILL_JOB (
    ID                             bigint NOT NULL
    , SE_ID                          bigint           NULL
    , SE_VERSION                     bigint           NULL
    , SME_ID                         bigint           NULL
    , SCOPE_ID                       bigint           NULL
    , STATE                          int8             NULL
    , EXIT_CODE                      int8             NULL
    , COMMANDLINE                    lvarchar(512)    NULL
    , LOGFILE                        lvarchar(512)    NULL
    , ERRLOGFILE                     lvarchar(512)    NULL
    , PID                            lvarchar(32)     NULL
    , EXTPID                         lvarchar(32)     NULL
    , ERROR_MSG                      lvarchar(256)    NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINSH_TS                       bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
