-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_STATE_PROFILE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , INITIAL_RSD_ID                 bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_STATE_PROFILE
ON RESOURCE_STATE_PROFILE(ID);
CREATE VIEW SCI_RESOURCE_STATE_PROFILE (ID,NAME,INITIAL_RSD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , INITIAL_RSD_ID                 AS INITIAL_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_STATE_PROFILE;
