-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_TRACE (
    R_ID                           bigint          NOT NULL
    , TAG                            lvarchar(64)        NULL
    , TRACE_INTERVAL                 int8                NULL
    , TRACE_BASE                     int8                NULL
    , TRACE_BASE_MULTIPLIER          int8            NOT NULL
    , TD0_AVG                        float           NOT NULL
    , TD1_AVG                        float           NOT NULL
    , TD2_AVG                        float           NOT NULL
    , LW_AVG                         float           NOT NULL
    , WRITE_TIME                     bigint          NOT NULL
    , LAST_WRITE                     bigint          NOT NULL
);
CREATE VIEW SCI_RESOURCE_TRACE (R_ID,TAG,TRACE_INTERVAL,TRACE_BASE,TRACE_BASE_MULTIPLIER,TD0_AVG,TD1_AVG,TD2_AVG,LW_AVG,WRITE_TIME,LAST_WRITE) AS
SELECT 
    R_ID                           AS R_ID
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , dbinfo ('utc_to_datetime', round(mod(WRITE_TIME, 1125899906842624)/1000)) AS WRITE_TIME
    , dbinfo ('utc_to_datetime', round(mod(LAST_WRITE, 1125899906842624)/1000)) AS LAST_WRITE
  FROM RESOURCE_TRACE;
