drop view sci_sme_quarter;
CREATE VIEW sci_sme_quarter (
        jahr,
        quartal,
        anzahl,
        expected_anzahl,
        avg_anzahl_pro_tag)
AS
SELECT  jahr,
        min((monat-1)/3+1),
        sum(anzahl),

        CASE DATE(TRIM(CHAR(jahr)) + '.' + RIGHT('0' + TRIM(CHAR(min(((monat-1)/3)*3+1))),2) + '.01')
        WHEN date_trunc('quarter', DATE('today')) THEN
                    int4( sum(anzahl)/(INTERVAL('days', DATE('today') - date_trunc('quarter', DATE('today'))) + 1) *
                               INTERVAL('days', date_trunc('quarter', DATE('today')) + '3 months' - date_trunc('quarter', DATE('today')))
                        )
        ELSE sum(anzahl)
        END,

        int4(avg(anzahl))
FROM sme_counter
GROUP BY jahr, (monat-1)/3;
\g
