-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVAL_DISPATCHER (
    ID                             decimal(20) NOT NULL
    , INT_ID                         decimal(20)     NOT NULL
    , SEQ_NO                         integer         NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , SELECT_INT_ID                  decimal(20)     WITH NULL
    , FILTER_INT_ID                  decimal(20)     WITH NULL
    , IS_ENABLED                     integer         NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
);\g
CREATE UNIQUE INDEX PK_INTERVAL_DISPATCHER
ON INTERVAL_DISPATCHER(ID) WITH STRUCTURE = BTREE;\g
CREATE VIEW SCI_INTERVAL_DISPATCHER AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , SEQ_NO                         AS SEQ_NO
    , NAME                           AS NAME
    , SELECT_INT_ID                  AS SELECT_INT_ID
    , FILTER_INT_ID                  AS FILTER_INT_ID
    , CASE IS_ENABLED WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS IS_ENABLED
    , CASE IS_ACTIVE WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CREATE_TS- decimal(CREATE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CHANGE_TS- decimal(CHANGE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CHANGE_TS
  FROM INTERVAL_DISPATCHER;\g
