-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [GROUPS] (
    [ID]                           decimal (38) NOT NULL
    , [NAME]                         varchar(64)     NOT NULL
    , [DELETE_VERSION]               decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_GROUPS
ON [GROUPS]([ID]);
go
CREATE VIEW SCI_GROUPS AS
SELECT 
    ID 
    , [NAME]                         AS [NAME]
    , [DELETE_VERSION]               AS [DELETE_VERSION]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [GROUPS];
go
