-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [INTERVAL_HIERARCHY] (
    [ID]                           decimal (38) NOT NULL
    , [CHILD_ID]                     decimal (38)    NOT NULL
    , [PARENT_ID]                    decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_INTERVAL_HIERARCHY
ON [INTERVAL_HIERARCHY]([ID]);
go
CREATE VIEW SCI_INTERVAL_HIERARCHY AS
SELECT 
    ID 
    , [CHILD_ID]                     AS [CHILD_ID]
    , [PARENT_ID]                    AS [PARENT_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [INTERVAL_HIERARCHY];
go
