-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [RESOURCE_TEMPLATE] (
    [ID]                           decimal (38) NOT NULL
    , [NR_ID]                        decimal (38)    NOT NULL
    , [SE_ID]                        decimal (38)    NOT NULL
    , [OWNER_ID]                     decimal (38)    NOT NULL
    , [RSD_ID]                       decimal (38)        NULL
    , [REQUESTABLE_AMOUNT]           integer             NULL
    , [AMOUNT]                       integer             NULL
    , [IS_ONLINE]                    integer         NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
    , [VALID_FROM]                 decimal (38) NOT NULL
    , [VALID_TO]                   decimal (38) NOT NULL
);
go
CREATE INDEX PK_RESOURCE_TEMPLATE
ON [RESOURCE_TEMPLATE]([ID]);
go
CREATE VIEW SCI_C_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , [NR_ID]                        AS [NR_ID]
    , [SE_ID]                        AS [SE_ID]
    , [OWNER_ID]                     AS [OWNER_ID]
    , [RSD_ID]                       AS [RSD_ID]
    , [REQUESTABLE_AMOUNT]           AS [REQUESTABLE_AMOUNT]
    , [AMOUNT]                       AS [AMOUNT]
    , CASE [IS_ONLINE] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_ONLINE]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [RESOURCE_TEMPLATE]
 WHERE VALID_TO = 9223372036854775807;
go
CREATE VIEW SCI_V_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , [NR_ID]                        AS [NR_ID]
    , [SE_ID]                        AS [SE_ID]
    , [OWNER_ID]                     AS [OWNER_ID]
    , [RSD_ID]                       AS [RSD_ID]
    , [REQUESTABLE_AMOUNT]           AS [REQUESTABLE_AMOUNT]
    , [AMOUNT]                       AS [AMOUNT]
    , CASE [IS_ONLINE] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_ONLINE]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , VALID_FROM
    , VALID_TO
  FROM [RESOURCE_TEMPLATE];
go
