-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `EXTENTS` (
    `ID`                           decimal(20) NOT NULL
    , `O_ID`                         decimal(20)     NOT NULL
    , `SME_ID`                       decimal(20)     NOT NULL
    , `SEQUENCE`                     integer         NOT NULL
    , `EXTENT`                       varchar(256)    NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
) ENGINE = INNODB;
CREATE UNIQUE INDEX PK_EXTENTS
ON `EXTENTS`(`ID`);
CREATE VIEW SCI_EXTENTS AS
SELECT 
    ID 
    , `O_ID`                         AS `O_ID`
    , `SME_ID`                       AS `SME_ID`
    , `SEQUENCE`                     AS `SEQUENCE`
    , `EXTENT`                       AS `EXTENT`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `EXTENTS`;
CREATE TABLE ARC_EXTENTS (
    ID                             decimal(20) NOT NULL
    , `O_ID`                         decimal(20)      NULL
    , `SME_ID`                       decimal(20)      NULL
    , `SEQUENCE`                     integer          NULL
    , `EXTENT`                       varchar(256)     NULL
    , `CREATOR_U_ID`                 decimal(20)      NULL
    , `CREATE_TS`                    decimal(20)      NULL
    , `CHANGER_U_ID`                 decimal(20)      NULL
    , `CHANGE_TS`                    decimal(20)      NULL
) ENGINE = INNODB;
