-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "OBJECT_COMMENT" (
    "ID"                           NUMBER (38) NOT NULL
    , "OBJECT_ID"                    NUMBER (38)          NOT NULL
    , "OBJECT_TYPE"                  NUMBER (38)          NOT NULL
    , "INFO_TYPE"                    NUMBER (38)          NOT NULL
    , "SEQUENCE_NUMBER"              NUMBER (38)          NOT NULL
    , "TAG"                          VARCHAR2 (64 CHAR)       NULL
    , "DESCRIPTION"                  VARCHAR2 (1900 CHAR) NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_OBJECT_COMMENT AS
SELECT 
    ID 
    , "OBJECT_ID"                    AS "OBJECT_ID"
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS "OBJECT_TYPE"
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS "INFO_TYPE"
    , "SEQUENCE_NUMBER"              AS "SEQUENCE_NUMBER"
    , "TAG"                          AS "TAG"
    , "DESCRIPTION"                  AS "DESCRIPTION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "OBJECT_COMMENT"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_OBJECT_COMMENT AS
SELECT 
    ID 
    , "OBJECT_ID"                    AS "OBJECT_ID"
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS "OBJECT_TYPE"
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS "INFO_TYPE"
    , "SEQUENCE_NUMBER"              AS "SEQUENCE_NUMBER"
    , "TAG"                          AS "TAG"
    , "DESCRIPTION"                  AS "DESCRIPTION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , VALID_FROM
    , VALID_TO
  FROM "OBJECT_COMMENT";
