-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "OBJECT_EVENT" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "TR_ID"                        NUMBER (38)              NULL
    , "OI_ID"                        NUMBER (38)          NOT NULL
    , "EVENT_TYPE"                   NUMBER (1)           NOT NULL
    , "SME_ID"                       NUMBER (38)          NOT NULL
    , "SE_ID"                        NUMBER (38)          NOT NULL
    , "SUBMIT_TS"                    NUMBER (38)              NULL
    , "FINAL_TS"                     NUMBER (38)              NULL
    , "FINAL_ESD_ID"                 NUMBER (38)              NULL
    , "MAIN_SME_ID"                  NUMBER (38)              NULL
    , "MAIN_SE_ID"                   NUMBER (38)              NULL
    , "MAIN_FINAL_TS"                NUMBER (38)              NULL
    , "MAIN_FINAL_ESD_ID"            NUMBER (38)              NULL
    , "SE_VERSION"                   NUMBER (38)          NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_OBJECT_EVENT AS
SELECT 
    ID 
    , "TR_ID"                        AS "TR_ID"
    , "OI_ID"                        AS "OI_ID"
    , DECODE (EVENT_TYPE, 1, 'CREATE', 2, 'CHANGE', 3, 'DELETE') AS "EVENT_TYPE"
    , "SME_ID"                       AS "SME_ID"
    , "SE_ID"                        AS "SE_ID"
    , pkg_time.gmt2local("SUBMIT_TS") AS "SUBMIT_TS"
    , pkg_time.gmt2local("FINAL_TS") AS "FINAL_TS"
    , "FINAL_ESD_ID"                 AS "FINAL_ESD_ID"
    , "MAIN_SME_ID"                  AS "MAIN_SME_ID"
    , "MAIN_SE_ID"                   AS "MAIN_SE_ID"
    , pkg_time.gmt2local("MAIN_FINAL_TS") AS "MAIN_FINAL_TS"
    , "MAIN_FINAL_ESD_ID"            AS "MAIN_FINAL_ESD_ID"
    , "SE_VERSION"                   AS "SE_VERSION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "OBJECT_EVENT";
