-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "POOLED_RESOURCE" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "P_ID"                         NUMBER (38)          NOT NULL
    , "R_ID"                         NUMBER (38)          NOT NULL
    , "IS_POOL"                      NUMBER (1)           NOT NULL
    , "IS_MANAGED"                   NUMBER (1)           NOT NULL
    , "NOM_PCT"                      NUMBER (38)          NOT NULL
    , "FREE_PCT"                     NUMBER (38)          NOT NULL
    , "MIN_PCT"                      NUMBER (38)          NOT NULL
    , "MAX_PCT"                      NUMBER (38)          NOT NULL
    , "ACT_IS_MANAGED"               NUMBER (1)           NOT NULL
    , "ACT_NOM_PCT"                  NUMBER (38)          NOT NULL
    , "ACT_FREE_PCT"                 NUMBER (38)          NOT NULL
    , "ACT_MIN_PCT"                  NUMBER (38)          NOT NULL
    , "ACT_MAX_PCT"                  NUMBER (38)          NOT NULL
    , "TARGET_AMOUNT"                NUMBER (38)          NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_POOLED_RESOURCE AS
SELECT 
    ID 
    , "P_ID"                         AS "P_ID"
    , "R_ID"                         AS "R_ID"
    , DECODE (IS_POOL, 1, 'TRUE', 0, 'FALSE') AS "IS_POOL"
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS "IS_MANAGED"
    , "NOM_PCT"                      AS "NOM_PCT"
    , "FREE_PCT"                     AS "FREE_PCT"
    , "MIN_PCT"                      AS "MIN_PCT"
    , "MAX_PCT"                      AS "MAX_PCT"
    , DECODE (ACT_IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS "ACT_IS_MANAGED"
    , "ACT_NOM_PCT"                  AS "ACT_NOM_PCT"
    , "ACT_FREE_PCT"                 AS "ACT_FREE_PCT"
    , "ACT_MIN_PCT"                  AS "ACT_MIN_PCT"
    , "ACT_MAX_PCT"                  AS "ACT_MAX_PCT"
    , "TARGET_AMOUNT"                AS "TARGET_AMOUNT"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "POOLED_RESOURCE";
