-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "SCHEDULE" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "NAME"                         VARCHAR2 (64 CHAR)   NOT NULL
    , "OWNER_ID"                     NUMBER (38)          NOT NULL
    , "INT_ID"                       NUMBER (38)              NULL
    , "PARENT_ID"                    NUMBER (38)              NULL
    , "TIME_ZONE"                    VARCHAR2 (32 CHAR)   NOT NULL
    , "SE_ID"                        NUMBER (38)              NULL
    , "ACTIVE"                       NUMBER (1)           NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "INHERIT_PRIVS"                NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_SCHEDULE AS
SELECT 
    ID 
    , "NAME"                         AS "NAME"
    , "OWNER_ID"                     AS "OWNER_ID"
    , "INT_ID"                       AS "INT_ID"
    , "PARENT_ID"                    AS "PARENT_ID"
    , "TIME_ZONE"                    AS "TIME_ZONE"
    , "SE_ID"                        AS "SE_ID"
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS "ACTIVE"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , "INHERIT_PRIVS"                AS "INHERIT_PRIVS"
  FROM "SCHEDULE";
