-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "VERSIONED_EXTENTS" (
    "ID"                           NUMBER (38) NOT NULL
    , "O_ID"                         NUMBER (38)          NOT NULL
    , "SEQUENCE"                     NUMBER (38)          NOT NULL
    , "EXTENT"                       VARCHAR2 (256 CHAR)  NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , "O_ID"                         AS "O_ID"
    , "SEQUENCE"                     AS "SEQUENCE"
    , "EXTENT"                       AS "EXTENT"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "VERSIONED_EXTENTS"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , "O_ID"                         AS "O_ID"
    , "SEQUENCE"                     AS "SEQUENCE"
    , "EXTENT"                       AS "EXTENT"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , VALID_FROM
    , VALID_TO
  FROM "VERSIONED_EXTENTS";
